/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.15.1
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"
        #include <wx/colourdata.h>
        #include <wx/colour.h>
        #include <wx/object.h>
        #include <wx/object.h>
        #include <wx/object.h>


class sipwxColourData : public ::wxColourData
{
public:
    sipwxColourData();
    sipwxColourData(const ::wxColourData&);
    ~sipwxColourData();

public:
    sipSimpleWrapper *sipPySelf;

private:
    sipwxColourData(const sipwxColourData &);
    sipwxColourData &operator = (const sipwxColourData &);
};

sipwxColourData::sipwxColourData(): ::wxColourData(), sipPySelf(SIP_NULLPTR)
{
}

sipwxColourData::sipwxColourData(const ::wxColourData& a0): ::wxColourData(a0), sipPySelf(SIP_NULLPTR)
{
}

sipwxColourData::~sipwxColourData()
{
    sipInstanceDestroyedEx(&sipPySelf);
}


PyDoc_STRVAR(doc_wxColourData_GetChooseFull, "GetChooseFull() -> bool\n"
"\n"
"Under Windows, determines whether the Windows colour dialog will\n"
"display the full dialog with custom colour selection controls.");

extern "C" {static PyObject *meth_wxColourData_GetChooseFull(PyObject *, PyObject *);}
static PyObject *meth_wxColourData_GetChooseFull(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxColourData *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxColourData, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetChooseFull();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_ColourData, sipName_GetChooseFull, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxColourData_GetChooseAlpha, "GetChooseAlpha() -> bool\n"
"\n"
"Indicates whether the colour dialog will display alpha values and an\n"
"opacity selector.");

extern "C" {static PyObject *meth_wxColourData_GetChooseAlpha(PyObject *, PyObject *);}
static PyObject *meth_wxColourData_GetChooseAlpha(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxColourData *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxColourData, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetChooseAlpha();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_ColourData, sipName_GetChooseAlpha, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxColourData_GetColour, "GetColour() -> Colour\n"
"\n"
"Gets the current colour associated with the colour dialog.");

extern "C" {static PyObject *meth_wxColourData_GetColour(PyObject *, PyObject *);}
static PyObject *meth_wxColourData_GetColour(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxColourData *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxColourData, &sipCpp))
        {
            ::wxColour*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->GetColour();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes, sipType_wxColour, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_ColourData, sipName_GetColour, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxColourData_GetCustomColour, "GetCustomColour(i) -> Colour\n"
"\n"
"Returns custom colours associated with the colour dialog.");

extern "C" {static PyObject *meth_wxColourData_GetCustomColour(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxColourData_GetCustomColour(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int i;
        const ::wxColourData *sipCpp;

        static const char *sipKwdList[] = {
            sipName_i,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxColourData, &sipCpp, &i))
        {
            ::wxColour*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxColour(sipCpp->GetCustomColour(i));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxColour, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_ColourData, sipName_GetCustomColour, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxColourData_SetChooseFull, "SetChooseFull(flag) -> None\n"
"\n"
"Under Windows, tells the Windows colour dialog to display the full\n"
"dialog with custom colour selection controls.");

extern "C" {static PyObject *meth_wxColourData_SetChooseFull(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxColourData_SetChooseFull(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool flag;
        ::wxColourData *sipCpp;

        static const char *sipKwdList[] = {
            sipName_flag,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bb", &sipSelf, sipType_wxColourData, &sipCpp, &flag))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetChooseFull(flag);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_ColourData, sipName_SetChooseFull, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxColourData_SetChooseAlpha, "SetChooseAlpha(flag) -> None\n"
"\n"
"Tells the colour dialog to show alpha values and an opacity selector\n"
"(slider).");

extern "C" {static PyObject *meth_wxColourData_SetChooseAlpha(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxColourData_SetChooseAlpha(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool flag;
        ::wxColourData *sipCpp;

        static const char *sipKwdList[] = {
            sipName_flag,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bb", &sipSelf, sipType_wxColourData, &sipCpp, &flag))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetChooseAlpha(flag);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_ColourData, sipName_SetChooseAlpha, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxColourData_SetColour, "SetColour(colour) -> None\n"
"\n"
"Sets the default colour for the colour dialog.");

extern "C" {static PyObject *meth_wxColourData_SetColour(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxColourData_SetColour(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxColour* colour;
        int colourState = 0;
        ::wxColourData *sipCpp;

        static const char *sipKwdList[] = {
            sipName_colour,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxColourData, &sipCpp, sipType_wxColour, &colour, &colourState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetColour(*colour);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxColour *>(colour), sipType_wxColour, colourState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_ColourData, sipName_SetColour, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxColourData_SetCustomColour, "SetCustomColour(i, colour) -> None\n"
"\n"
"Sets custom colours for the colour dialog.");

extern "C" {static PyObject *meth_wxColourData_SetCustomColour(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxColourData_SetCustomColour(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int i;
        const ::wxColour* colour;
        int colourState = 0;
        ::wxColourData *sipCpp;

        static const char *sipKwdList[] = {
            sipName_i,
            sipName_colour,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BiJ1", &sipSelf, sipType_wxColourData, &sipCpp, &i, sipType_wxColour, &colour, &colourState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetCustomColour(i, *colour);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxColour *>(colour), sipType_wxColour, colourState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_ColourData, sipName_SetCustomColour, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxColourData_ToString, "ToString() -> str\n"
"\n"
"Converts the colours saved in this class in a string form, separating\n"
"the various colours with a comma.");

extern "C" {static PyObject *meth_wxColourData_ToString(PyObject *, PyObject *);}
static PyObject *meth_wxColourData_ToString(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxColourData *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxColourData, &sipCpp))
        {
            ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxString(sipCpp->ToString());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_ColourData, sipName_ToString, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxColourData_FromString, "FromString(str) -> bool\n"
"\n"
"Decodes the given string, which should be in the same format returned\n"
"by ToString(), and sets the internal colours.");

extern "C" {static PyObject *meth_wxColourData_FromString(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxColourData_FromString(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxString* str;
        int strState = 0;
        ::wxColourData *sipCpp;

        static const char *sipKwdList[] = {
            sipName_str,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxColourData, &sipCpp, sipType_wxString, &str, &strState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->FromString(*str);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(str), sipType_wxString, strState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_ColourData, sipName_FromString, SIP_NULLPTR);

    return SIP_NULLPTR;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_wxColourData(void *, const sipTypeDef *);}
static void *cast_wxColourData(void *sipCppV, const sipTypeDef *targetType)
{
    ::wxColourData *sipCpp = reinterpret_cast< ::wxColourData *>(sipCppV);

    if (targetType == sipType_wxColourData)
        return sipCppV;

    if (targetType == sipType_wxObject)
        return static_cast< ::wxObject *>(sipCpp);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxColourData(void *, int);}
static void release_wxColourData(void *sipCppV, int sipState)
{
    Py_BEGIN_ALLOW_THREADS

    if (sipState & SIP_DERIVED_CLASS)
        delete reinterpret_cast<sipwxColourData *>(sipCppV);
    else
        delete reinterpret_cast< ::wxColourData *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void *array_wxColourData(Py_ssize_t);}
static void *array_wxColourData(Py_ssize_t sipNrElem)
{
    return new ::wxColourData[sipNrElem];
}


extern "C" {static void array_delete_wxColourData(void *);}
static void array_delete_wxColourData(void *sipCpp)
{
    delete[] reinterpret_cast< ::wxColourData *>(sipCpp);
}


extern "C" {static void assign_wxColourData(void *, Py_ssize_t, void *);}
static void assign_wxColourData(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::wxColourData *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::wxColourData *>(sipSrc);
}


extern "C" {static void *copy_wxColourData(const void *, Py_ssize_t);}
static void *copy_wxColourData(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new ::wxColourData(reinterpret_cast<const ::wxColourData *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_wxColourData(sipSimpleWrapper *);}
static void dealloc_wxColourData(sipSimpleWrapper *sipSelf)
{
    if (sipIsDerivedClass(sipSelf))
        reinterpret_cast<sipwxColourData *>(sipGetAddress(sipSelf))->sipPySelf = SIP_NULLPTR;

    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxColourData(sipGetAddress(sipSelf), sipIsDerivedClass(sipSelf));
    }
}


extern "C" {static void *init_type_wxColourData(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxColourData(sipSimpleWrapper *sipSelf, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    sipwxColourData *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxColourData();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    {
        const ::wxColourData* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_wxColourData, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxColourData(*a0);
            Py_END_ALLOW_THREADS

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_wxColourData[] = {{398, 255, 1}};


static PyMethodDef methods_wxColourData[] = {
    {sipName_FromString, SIP_MLMETH_CAST(meth_wxColourData_FromString), METH_VARARGS|METH_KEYWORDS, doc_wxColourData_FromString},
    {sipName_GetChooseAlpha, meth_wxColourData_GetChooseAlpha, METH_VARARGS, doc_wxColourData_GetChooseAlpha},
    {sipName_GetChooseFull, meth_wxColourData_GetChooseFull, METH_VARARGS, doc_wxColourData_GetChooseFull},
    {sipName_GetColour, meth_wxColourData_GetColour, METH_VARARGS, doc_wxColourData_GetColour},
    {sipName_GetCustomColour, SIP_MLMETH_CAST(meth_wxColourData_GetCustomColour), METH_VARARGS|METH_KEYWORDS, doc_wxColourData_GetCustomColour},
    {sipName_SetChooseAlpha, SIP_MLMETH_CAST(meth_wxColourData_SetChooseAlpha), METH_VARARGS|METH_KEYWORDS, doc_wxColourData_SetChooseAlpha},
    {sipName_SetChooseFull, SIP_MLMETH_CAST(meth_wxColourData_SetChooseFull), METH_VARARGS|METH_KEYWORDS, doc_wxColourData_SetChooseFull},
    {sipName_SetColour, SIP_MLMETH_CAST(meth_wxColourData_SetColour), METH_VARARGS|METH_KEYWORDS, doc_wxColourData_SetColour},
    {sipName_SetCustomColour, SIP_MLMETH_CAST(meth_wxColourData_SetCustomColour), METH_VARARGS|METH_KEYWORDS, doc_wxColourData_SetCustomColour},
    {sipName_ToString, meth_wxColourData_ToString, METH_VARARGS, doc_wxColourData_ToString}
};

static sipEnumMemberDef enummembers_wxColourData[] = {
    {sipName_NUM_CUSTOM, static_cast<int>(::wxColourData::NUM_CUSTOM), -1},
};

sipVariableDef variables_wxColourData[] = {
    {PropertyVariable, sipName_Colour, &methods_wxColourData[3], &methods_wxColourData[7], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_ChooseFull, &methods_wxColourData[2], &methods_wxColourData[6], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_ChooseAlpha, &methods_wxColourData[1], &methods_wxColourData[5], SIP_NULLPTR, SIP_NULLPTR},
};

PyDoc_STRVAR(doc_wxColourData, "ColourData() -> None\n"
"\n"
"This class holds a variety of information related to colour dialogs.");


sipClassTypeDef sipTypeDef__core_wxColourData = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SCC|SIP_TYPE_CLASS,
        sipNameNr_wxColourData,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        sipNameNr_ColourData,
        {0, 0, 1},
        10, methods_wxColourData,
        1, enummembers_wxColourData,
        3, variables_wxColourData,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxColourData,
    -1,
    -1,
    supers_wxColourData,
    SIP_NULLPTR,
    init_type_wxColourData,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_wxColourData,
    assign_wxColourData,
    array_wxColourData,
    copy_wxColourData,
    release_wxColourData,
    cast_wxColourData,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    array_delete_wxColourData,
    sizeof (::wxColourData),
};
