/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.15.1
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_html2.h"
        #include <wx/webview.h>
        #include <wx/gdicmn.h>
        #include <wx/gdicmn.h>
        #include <wx/webview.h>


PyDoc_STRVAR(doc_wxWebViewWindowFeatures_GetChildWebView, "GetChildWebView() -> WebView\n"
"\n"
"Get the child web view for the target window.");

extern "C" {static PyObject *meth_wxWebViewWindowFeatures_GetChildWebView(PyObject *, PyObject *);}
static PyObject *meth_wxWebViewWindowFeatures_GetChildWebView(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxWebViewWindowFeatures *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxWebViewWindowFeatures, &sipCpp))
        {
            ::wxWebView*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetChildWebView();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes, sipType_wxWebView, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_WebViewWindowFeatures, sipName_GetChildWebView, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxWebViewWindowFeatures_GetPosition, "GetPosition() -> wx.Point\n"
"\n"
"Returns the position of the new window if specified by a window.open()\n"
"call.");

extern "C" {static PyObject *meth_wxWebViewWindowFeatures_GetPosition(PyObject *, PyObject *);}
static PyObject *meth_wxWebViewWindowFeatures_GetPosition(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    PyObject *sipOrigSelf = sipSelf;

    {
        const ::wxWebViewWindowFeatures *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxWebViewWindowFeatures, &sipCpp))
        {
            ::wxPoint*sipRes;

            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_WebViewWindowFeatures, sipName_GetPosition);
                return SIP_NULLPTR;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxPoint(sipCpp->GetPosition());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxPoint, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_WebViewWindowFeatures, sipName_GetPosition, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxWebViewWindowFeatures_GetSize, "GetSize() -> wx.Size\n"
"\n"
"Returns the size of the new window if specified by a window.open()\n"
"call.");

extern "C" {static PyObject *meth_wxWebViewWindowFeatures_GetSize(PyObject *, PyObject *);}
static PyObject *meth_wxWebViewWindowFeatures_GetSize(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    PyObject *sipOrigSelf = sipSelf;

    {
        const ::wxWebViewWindowFeatures *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxWebViewWindowFeatures, &sipCpp))
        {
            ::wxSize*sipRes;

            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_WebViewWindowFeatures, sipName_GetSize);
                return SIP_NULLPTR;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxSize(sipCpp->GetSize());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxSize, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_WebViewWindowFeatures, sipName_GetSize, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxWebViewWindowFeatures_ShouldDisplayMenuBar, "ShouldDisplayMenuBar() -> bool\n"
"\n"
"Returns true if the target window is expected to display a menu bar as\n"
"specified by a window.open() call.");

extern "C" {static PyObject *meth_wxWebViewWindowFeatures_ShouldDisplayMenuBar(PyObject *, PyObject *);}
static PyObject *meth_wxWebViewWindowFeatures_ShouldDisplayMenuBar(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    PyObject *sipOrigSelf = sipSelf;

    {
        const ::wxWebViewWindowFeatures *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxWebViewWindowFeatures, &sipCpp))
        {
            bool sipRes;

            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_WebViewWindowFeatures, sipName_ShouldDisplayMenuBar);
                return SIP_NULLPTR;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->ShouldDisplayMenuBar();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_WebViewWindowFeatures, sipName_ShouldDisplayMenuBar, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxWebViewWindowFeatures_ShouldDisplayStatusBar, "ShouldDisplayStatusBar() -> bool\n"
"\n"
"Returns true if the target window is expected to display a status bar\n"
"as specified by a window.open() call.");

extern "C" {static PyObject *meth_wxWebViewWindowFeatures_ShouldDisplayStatusBar(PyObject *, PyObject *);}
static PyObject *meth_wxWebViewWindowFeatures_ShouldDisplayStatusBar(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    PyObject *sipOrigSelf = sipSelf;

    {
        const ::wxWebViewWindowFeatures *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxWebViewWindowFeatures, &sipCpp))
        {
            bool sipRes;

            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_WebViewWindowFeatures, sipName_ShouldDisplayStatusBar);
                return SIP_NULLPTR;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->ShouldDisplayStatusBar();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_WebViewWindowFeatures, sipName_ShouldDisplayStatusBar, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxWebViewWindowFeatures_ShouldDisplayToolBar, "ShouldDisplayToolBar() -> bool\n"
"\n"
"Returns true if the target window is expected to display a tool bar as\n"
"specified by a window.open() call.");

extern "C" {static PyObject *meth_wxWebViewWindowFeatures_ShouldDisplayToolBar(PyObject *, PyObject *);}
static PyObject *meth_wxWebViewWindowFeatures_ShouldDisplayToolBar(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    PyObject *sipOrigSelf = sipSelf;

    {
        const ::wxWebViewWindowFeatures *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxWebViewWindowFeatures, &sipCpp))
        {
            bool sipRes;

            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_WebViewWindowFeatures, sipName_ShouldDisplayToolBar);
                return SIP_NULLPTR;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->ShouldDisplayToolBar();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_WebViewWindowFeatures, sipName_ShouldDisplayToolBar, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxWebViewWindowFeatures_ShouldDisplayScrollBars, "ShouldDisplayScrollBars() -> bool\n"
"\n"
"Returns true if the target window is expected to display scroll bars\n"
"as specified by a window.open() call.");

extern "C" {static PyObject *meth_wxWebViewWindowFeatures_ShouldDisplayScrollBars(PyObject *, PyObject *);}
static PyObject *meth_wxWebViewWindowFeatures_ShouldDisplayScrollBars(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    PyObject *sipOrigSelf = sipSelf;

    {
        const ::wxWebViewWindowFeatures *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxWebViewWindowFeatures, &sipCpp))
        {
            bool sipRes;

            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_WebViewWindowFeatures, sipName_ShouldDisplayScrollBars);
                return SIP_NULLPTR;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->ShouldDisplayScrollBars();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_WebViewWindowFeatures, sipName_ShouldDisplayScrollBars, SIP_NULLPTR);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxWebViewWindowFeatures(void *, int);}
static void release_wxWebViewWindowFeatures(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxWebViewWindowFeatures *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void dealloc_wxWebViewWindowFeatures(sipSimpleWrapper *);}
static void dealloc_wxWebViewWindowFeatures(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxWebViewWindowFeatures(sipGetAddress(sipSelf), 0);
    }
}


static PyMethodDef methods_wxWebViewWindowFeatures[] = {
    {sipName_GetChildWebView, meth_wxWebViewWindowFeatures_GetChildWebView, METH_VARARGS, doc_wxWebViewWindowFeatures_GetChildWebView},
    {sipName_GetPosition, meth_wxWebViewWindowFeatures_GetPosition, METH_VARARGS, doc_wxWebViewWindowFeatures_GetPosition},
    {sipName_GetSize, meth_wxWebViewWindowFeatures_GetSize, METH_VARARGS, doc_wxWebViewWindowFeatures_GetSize},
    {sipName_ShouldDisplayMenuBar, meth_wxWebViewWindowFeatures_ShouldDisplayMenuBar, METH_VARARGS, doc_wxWebViewWindowFeatures_ShouldDisplayMenuBar},
    {sipName_ShouldDisplayScrollBars, meth_wxWebViewWindowFeatures_ShouldDisplayScrollBars, METH_VARARGS, doc_wxWebViewWindowFeatures_ShouldDisplayScrollBars},
    {sipName_ShouldDisplayStatusBar, meth_wxWebViewWindowFeatures_ShouldDisplayStatusBar, METH_VARARGS, doc_wxWebViewWindowFeatures_ShouldDisplayStatusBar},
    {sipName_ShouldDisplayToolBar, meth_wxWebViewWindowFeatures_ShouldDisplayToolBar, METH_VARARGS, doc_wxWebViewWindowFeatures_ShouldDisplayToolBar}
};

sipVariableDef variables_wxWebViewWindowFeatures[] = {
    {PropertyVariable, sipName_Size, &methods_wxWebViewWindowFeatures[2], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Position, &methods_wxWebViewWindowFeatures[1], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_ChildWebView, &methods_wxWebViewWindowFeatures[0], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
};

PyDoc_STRVAR(doc_wxWebViewWindowFeatures, "A class describing the window information for a new child window.");


sipClassTypeDef sipTypeDef__html2_wxWebViewWindowFeatures = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_ABSTRACT|SIP_TYPE_CLASS,
        sipNameNr_wxWebViewWindowFeatures,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        sipNameNr_WebViewWindowFeatures,
        {0, 0, 1},
        7, methods_wxWebViewWindowFeatures,
        0, SIP_NULLPTR,
        3, variables_wxWebViewWindowFeatures,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxWebViewWindowFeatures,
    -1,
    -1,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_wxWebViewWindowFeatures,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    release_wxWebViewWindowFeatures,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    0,
};
