Welcome to wxWidgets, a free and open source cross-platform C++ framework for writing advanced GUI applications using native controls.

wxWidgets 3.3.2 is the second release in the 3.3.x development series coming soon after 3.3.0 and is mostly a bug fix release, correcting some regressions found in 3.3.0.

Please note that even this is not a "stable" release, it is still considered to be suitable to be used in production, the only difference with the stable releases is that API and ABI compatibility are not guaranteed for the releases in this series. In practice, however, backwards-incompatible API changes are expected to be rare.

Please see [**README**](https://raw.githubusercontent.com/wxWidgets/wxWidgets/v3.3.2/docs/readme.txt) for more information about this release and the [change log](https://raw.githubusercontent.com/wxWidgets/wxWidgets/v3.3.1/docs/changes.txt) for more details of the changes in it. In particular, please read the "INCOMPATIBLE CHANGES" section in the change log if you are upgrading from a previous version of wxWidgets.


## Source Files and Documentation

If you intend to build wxWidgets from sources (which is recommended), please do **NOT** download the files using the "Source code" links just above, which are automatically generated by GitHub and don't contain the submodules sources which are necessary for building wxWidgets.

Instead, download one of [wxWidgets-3.3.2.zip](https://github.com/wxWidgets/wxWidgets/releases/download/v3.3.1/wxWidgets-3.3.1.zip) or [wxWidgets-3.3.1.7z](https://github.com/wxWidgets/wxWidgets/releases/download/v3.3.1/wxWidgets-3.3.1.7z), for much smaller size, for Microsoft Windows systems or [wxWidgets-3.3.1.tar.bz2](https://github.com/wxWidgets/wxWidgets/releases/download/v3.3.1/wxWidgets-3.3.1.tar.bz2) for Unix ones, including macOS. These archives have exactly the same contents, but use the line endings appropriate for the corresponding platform.

In addition, we provide archives containing the documentation in either HTML or Microsoft CHM formats. Notice that the documentation is also [available online](https://docs.wxwidgets.org/3.3.2).

Finally, Microsoft Windows users may download [Setup.exe file](https://github.com/wxWidgets/wxWidgets/releases/download/v3.3.2/wxMSW-3.3.1-Setup.exe) containing both sources and documentation, however please note that this file does _not_ contain any binaries, please see below for those.

To verify your download please use the following SHA-1 checksums:

    b13e4a04347366ccf06060ce1637ef3eb17beb42  wxMSW-3.3.2-Setup.exe
    c20c6a021f343d4b2e495df7ddbf6f6aebba0f37  wxWidgets-3.3.2-docs-chm.zip
    973c799cef757f1513264e5075f555f604de13bb  wxWidgets-3.3.2-docs-html.tar.bz2
    9e91c607737d4c7728360c8b0229829daec5df59  wxWidgets-3.3.2-docs-html.zip
    ae050d701a451ceb2e230aa6cd5222dd5258c76c  wxWidgets-3.3.2-headers.7z
    5e814eba0cb4bdb30b81d6ede28b00ee1384a3ce  wxWidgets-3.3.2.7z
    4011a6b56f13becc9b4a672d0a082041b22f499f  wxWidgets-3.3.2.tar.bz2
    2526b67fd855ebf3e7133fb8a91b48e5b4b03f70  wxWidgets-3.3.2.zip

## Binaries

We provide pre-built binary files for x86-64 Windows for the following compilers:

* Microsoft Visual C++ compiler versions 14.0, 14.1, 14.2 and 14.3 (corresponding to marketing product names of Microsoft Visual Studio 2015, 2017, 2019 and 2022 respectively). Please note that MSVC 14.x versions are ABI-compatible and the same set of binaries is used for all of them.
* gcc 15.1 provided by [MSYS2](https://www.msys2.org/) MINGW64 environment.

### For Developers

For developing applications with wxWidgets you need to download the compiler-independent `wxWidgets-3.3.2_Headers.7z` file and one of `wxMSW-3.3.1-vc14x_x64_Dev.7z` or `wxMSW-3.3.1_gcc1510_x64_Dev.7z` files depending on your compiler.

Unpack both files into the same directory so that `include` and `lib` directories are at the same level after unpacking. You should be able to compile and link applications using wxWidgets in both debug and release modes but the debug symbols are provided only for debug libraries in this archive, see below for the release build debug symbols.

Note that if you're setting up a new project using these binaries, the simplest way to do it is to use the provided `wxwidgets.props` file: for this, open the `View|Property Manager` menu item in the IDE, select "Add Existing Property Sheet..." from the project context menu and browse to this file in the file open dialog.

Please see the [instructions in the manual](https://docs.wxwidgets.org/3.3.2/plat_msw_binaries.html) for more details.

### For End Users

End users may download one of `wxMSW-3.3.2_vc14x_x64_ReleaseDLL.7z` or `wxMSW-3.3.1_gcc1510_x64_ReleaseDLL.7z` files to get just the DLLs required for running the applications using wxWidgets.

### For Debugging

* Microsoft Visual C++ users: File `wxMSW-3.3.2_vc14x_x64_ReleasePDB.7z` contains the debug symbols for the release build of the DLLs. Download it if you want to debug your own applications in release build or if you want to get meaningful information from mini-dumps retrieved from your users machines.
* gcc users: Currently the debug symbols are not available for the release build of the DLLs (only the debug versions of the DLLs contain the debug symbols).

### Binary File Download Verification

To verify your download please use the following SHA-1 checksums:

    e65fff19578141672258c30464faf9808fa2f814 wxMSW-3.3.2_gcc1510_x64_Dev.7z
    1ce14ee14e2129d816fc17f18d3c3ac74aa1bbd0 wxMSW-3.3.2_gcc1510_x64_ReleaseDLL.7zz
    44c389ac2691fdd20d7a622e58fc3064eb965c06 wxMSW-3.3.2_vc14x_x64_Dev.7z
    6713f2d41f5b26ef3ab225654f97d401a73beff8 wxMSW-3.3.2_vc14x_x64_ReleaseDLL.7z
    c90999d75fe000c784a60a52ab88acb213863e48 wxMSW-3.3.2_vc14x_x64_ReleasePDB.7z

## Reporting Problems

Please report bugs to the [issue tracker](https://github.com/wxWidgets/wxWidgets/issues/new) or the [wx-users mailing list](http://groups.google.com/group/wx-users).
