/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.15.1
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"
        #include <wx/textctrl.h>



PyDoc_STRVAR(doc_wxTextSearch_SearchValue, "SearchValue(value) -> TextSearch\n"
"\n"
"The string to search for.");

extern "C" {static PyObject *meth_wxTextSearch_SearchValue(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextSearch_SearchValue(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxString* value;
        int valueState = 0;
        ::wxTextSearch *sipCpp;

        static const char *sipKwdList[] = {
            sipName_value,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxTextSearch, &sipCpp, sipType_wxString, &value, &valueState))
        {
            ::wxTextSearch*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->SearchValue(*value);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(value), sipType_wxString, valueState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes, sipType_wxTextSearch, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_TextSearch, sipName_SearchValue, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextSearch_MatchCase, "MatchCase(matchCase=True) -> TextSearch\n"
"\n"
"Whether the search should match case (i.e., be case sensitive).");

extern "C" {static PyObject *meth_wxTextSearch_MatchCase(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextSearch_MatchCase(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool matchCase = 1;
        ::wxTextSearch *sipCpp;

        static const char *sipKwdList[] = {
            sipName_matchCase,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|b", &sipSelf, sipType_wxTextSearch, &sipCpp, &matchCase))
        {
            ::wxTextSearch*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->MatchCase(matchCase);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes, sipType_wxTextSearch, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_TextSearch, sipName_MatchCase, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextSearch_MatchWholeWord, "MatchWholeWord(matchWholeWord=True) -> TextSearch\n"
"\n"
"Whether the search should match the whole word.");

extern "C" {static PyObject *meth_wxTextSearch_MatchWholeWord(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextSearch_MatchWholeWord(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool matchWholeWord = 1;
        ::wxTextSearch *sipCpp;

        static const char *sipKwdList[] = {
            sipName_matchWholeWord,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|b", &sipSelf, sipType_wxTextSearch, &sipCpp, &matchWholeWord))
        {
            ::wxTextSearch*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->MatchWholeWord(matchWholeWord);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes, sipType_wxTextSearch, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_TextSearch, sipName_MatchWholeWord, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextSearch_SearchDirection, "SearchDirection(direction) -> TextSearch\n"
"\n"
"Whether the search should go up or down in the text control.");

extern "C" {static PyObject *meth_wxTextSearch_SearchDirection(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextSearch_SearchDirection(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxTextSearch::Direction direction;
        ::wxTextSearch *sipCpp;

        static const char *sipKwdList[] = {
            sipName_direction,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BE", &sipSelf, sipType_wxTextSearch, &sipCpp, sipType_wxTextSearch_Direction, &direction))
        {
            ::wxTextSearch*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->SearchDirection(direction);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes, sipType_wxTextSearch, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_TextSearch, sipName_SearchDirection, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxTextSearch_Start, "Start(startPosition) -> TextSearch\n"
"\n"
"Where the search should start from.");

extern "C" {static PyObject *meth_wxTextSearch_Start(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxTextSearch_Start(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        long startPosition;
        ::wxTextSearch *sipCpp;

        static const char *sipKwdList[] = {
            sipName_startPosition,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bl", &sipSelf, sipType_wxTextSearch, &sipCpp, &startPosition))
        {
            ::wxTextSearch*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->Start(startPosition);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes, sipType_wxTextSearch, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_TextSearch, sipName_Start, SIP_NULLPTR);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxTextSearch(void *, int);}
static void release_wxTextSearch(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxTextSearch *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void assign_wxTextSearch(void *, Py_ssize_t, void *);}
static void assign_wxTextSearch(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::wxTextSearch *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::wxTextSearch *>(sipSrc);
}


extern "C" {static void *copy_wxTextSearch(const void *, Py_ssize_t);}
static void *copy_wxTextSearch(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new ::wxTextSearch(reinterpret_cast<const ::wxTextSearch *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_wxTextSearch(sipSimpleWrapper *);}
static void dealloc_wxTextSearch(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxTextSearch(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxTextSearch(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxTextSearch(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    ::wxTextSearch *sipCpp = SIP_NULLPTR;

    {
        const ::wxString* text;
        int textState = 0;

        static const char *sipKwdList[] = {
            sipName_text,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J1", sipType_wxString, &text, &textState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new ::wxTextSearch(*text);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(text), sipType_wxString, textState);

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        const ::wxTextSearch* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_wxTextSearch, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new ::wxTextSearch(*a0);
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


static PyMethodDef methods_wxTextSearch[] = {
    {sipName_MatchCase, SIP_MLMETH_CAST(meth_wxTextSearch_MatchCase), METH_VARARGS|METH_KEYWORDS, doc_wxTextSearch_MatchCase},
    {sipName_MatchWholeWord, SIP_MLMETH_CAST(meth_wxTextSearch_MatchWholeWord), METH_VARARGS|METH_KEYWORDS, doc_wxTextSearch_MatchWholeWord},
    {sipName_SearchDirection, SIP_MLMETH_CAST(meth_wxTextSearch_SearchDirection), METH_VARARGS|METH_KEYWORDS, doc_wxTextSearch_SearchDirection},
    {sipName_SearchValue, SIP_MLMETH_CAST(meth_wxTextSearch_SearchValue), METH_VARARGS|METH_KEYWORDS, doc_wxTextSearch_SearchValue},
    {sipName_Start, SIP_MLMETH_CAST(meth_wxTextSearch_Start), METH_VARARGS|METH_KEYWORDS, doc_wxTextSearch_Start}
};

static sipEnumMemberDef enummembers_wxTextSearch[] = {
    {sipName_Down, static_cast<int>(::wxTextSearch::Direction::Down), 598},
    {sipName_Up, static_cast<int>(::wxTextSearch::Direction::Up), 598},
};


extern "C" {static PyObject *varget_wxTextSearch_m_direction(void *, PyObject *, PyObject *);}
static PyObject *varget_wxTextSearch_m_direction(void *sipSelf, PyObject *, PyObject *)
{
    ::wxTextSearch::Direction sipVal;
    ::wxTextSearch *sipCpp = reinterpret_cast< ::wxTextSearch *>(sipSelf);

    sipVal = sipCpp->m_direction;

    return sipConvertFromEnum(static_cast<int>(sipVal), sipType_wxTextSearch_Direction);
}


extern "C" {static int varset_wxTextSearch_m_direction(void *, PyObject *, PyObject *);}
static int varset_wxTextSearch_m_direction(void *sipSelf, PyObject *sipPy, PyObject *)
{
    ::wxTextSearch::Direction sipVal;
    ::wxTextSearch *sipCpp = reinterpret_cast< ::wxTextSearch *>(sipSelf);

    sipVal = (::wxTextSearch::Direction)sipConvertToEnum(sipPy, sipType_wxTextSearch_Direction);

    if (PyErr_Occurred() != SIP_NULLPTR)
        return -1;

    sipCpp->m_direction = sipVal;

    return 0;
}


extern "C" {static PyObject *varget_wxTextSearch_m_matchCase(void *, PyObject *, PyObject *);}
static PyObject *varget_wxTextSearch_m_matchCase(void *sipSelf, PyObject *, PyObject *)
{
    bool sipVal;
    ::wxTextSearch *sipCpp = reinterpret_cast< ::wxTextSearch *>(sipSelf);

    sipVal = sipCpp->m_matchCase;

    return PyBool_FromLong(sipVal);
}


extern "C" {static int varset_wxTextSearch_m_matchCase(void *, PyObject *, PyObject *);}
static int varset_wxTextSearch_m_matchCase(void *sipSelf, PyObject *sipPy, PyObject *)
{
    int sipVal;
    ::wxTextSearch *sipCpp = reinterpret_cast< ::wxTextSearch *>(sipSelf);

    sipVal = sipConvertToBool(sipPy);

    if (sipVal < 0)
        return -1;

    sipCpp->m_matchCase = static_cast<bool>(sipVal);

    return 0;
}


extern "C" {static PyObject *varget_wxTextSearch_m_searchValue(void *, PyObject *, PyObject *);}
static PyObject *varget_wxTextSearch_m_searchValue(void *sipSelf, PyObject *, PyObject *)
{
    ::wxString*sipVal;
    ::wxTextSearch *sipCpp = reinterpret_cast< ::wxTextSearch *>(sipSelf);

    sipVal = &sipCpp->m_searchValue;

    return sipConvertFromType(sipVal, sipType_wxString, SIP_NULLPTR);
}


extern "C" {static int varset_wxTextSearch_m_searchValue(void *, PyObject *, PyObject *);}
static int varset_wxTextSearch_m_searchValue(void *sipSelf, PyObject *sipPy, PyObject *)
{
    ::wxString*sipVal;
    ::wxTextSearch *sipCpp = reinterpret_cast< ::wxTextSearch *>(sipSelf);

    int sipIsErr = 0;
    int sipValState;
    sipVal = reinterpret_cast< ::wxString *>(sipForceConvertToType(sipPy, sipType_wxString, SIP_NULLPTR, SIP_NOT_NONE, &sipValState, &sipIsErr));

    if (sipIsErr)
        return -1;

    sipCpp->m_searchValue = *sipVal;

    sipReleaseType(sipVal, sipType_wxString, sipValState);

    return 0;
}


extern "C" {static PyObject *varget_wxTextSearch_m_startingPosition(void *, PyObject *, PyObject *);}
static PyObject *varget_wxTextSearch_m_startingPosition(void *sipSelf, PyObject *, PyObject *)
{
    long sipVal;
    ::wxTextSearch *sipCpp = reinterpret_cast< ::wxTextSearch *>(sipSelf);

    sipVal = sipCpp->m_startingPosition;

    return PyLong_FromLong(sipVal);
}


extern "C" {static int varset_wxTextSearch_m_startingPosition(void *, PyObject *, PyObject *);}
static int varset_wxTextSearch_m_startingPosition(void *sipSelf, PyObject *sipPy, PyObject *)
{
    long sipVal;
    ::wxTextSearch *sipCpp = reinterpret_cast< ::wxTextSearch *>(sipSelf);

    sipVal = sipLong_AsLong(sipPy);

    if (PyErr_Occurred() != SIP_NULLPTR)
        return -1;

    sipCpp->m_startingPosition = sipVal;

    return 0;
}


extern "C" {static PyObject *varget_wxTextSearch_m_wholeWord(void *, PyObject *, PyObject *);}
static PyObject *varget_wxTextSearch_m_wholeWord(void *sipSelf, PyObject *, PyObject *)
{
    bool sipVal;
    ::wxTextSearch *sipCpp = reinterpret_cast< ::wxTextSearch *>(sipSelf);

    sipVal = sipCpp->m_wholeWord;

    return PyBool_FromLong(sipVal);
}


extern "C" {static int varset_wxTextSearch_m_wholeWord(void *, PyObject *, PyObject *);}
static int varset_wxTextSearch_m_wholeWord(void *sipSelf, PyObject *sipPy, PyObject *)
{
    int sipVal;
    ::wxTextSearch *sipCpp = reinterpret_cast< ::wxTextSearch *>(sipSelf);

    sipVal = sipConvertToBool(sipPy);

    if (sipVal < 0)
        return -1;

    sipCpp->m_wholeWord = static_cast<bool>(sipVal);

    return 0;
}

sipVariableDef variables_wxTextSearch[] = {
    {InstanceVariable, sipName_m_direction, (PyMethodDef *)varget_wxTextSearch_m_direction, (PyMethodDef *)varset_wxTextSearch_m_direction, SIP_NULLPTR, SIP_NULLPTR},
    {InstanceVariable, sipName_m_matchCase, (PyMethodDef *)varget_wxTextSearch_m_matchCase, (PyMethodDef *)varset_wxTextSearch_m_matchCase, SIP_NULLPTR, SIP_NULLPTR},
    {InstanceVariable, sipName_m_searchValue, (PyMethodDef *)varget_wxTextSearch_m_searchValue, (PyMethodDef *)varset_wxTextSearch_m_searchValue, SIP_NULLPTR, SIP_NULLPTR},
    {InstanceVariable, sipName_m_startingPosition, (PyMethodDef *)varget_wxTextSearch_m_startingPosition, (PyMethodDef *)varset_wxTextSearch_m_startingPosition, SIP_NULLPTR, SIP_NULLPTR},
    {InstanceVariable, sipName_m_wholeWord, (PyMethodDef *)varget_wxTextSearch_m_wholeWord, (PyMethodDef *)varset_wxTextSearch_m_wholeWord, SIP_NULLPTR, SIP_NULLPTR},
};

PyDoc_STRVAR(doc_wxTextSearch, "TextSearch(text) -> None\n"
"\n"
"Search options for wxTextCtrl::SearchText().");


sipClassTypeDef sipTypeDef__core_wxTextSearch = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_CLASS,
        sipNameNr_wxTextSearch,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        sipNameNr_TextSearch,
        {0, 0, 1},
        5, methods_wxTextSearch,
        2, enummembers_wxTextSearch,
        5, variables_wxTextSearch,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxTextSearch,
    -1,
    -1,
    SIP_NULLPTR,
    SIP_NULLPTR,
    init_type_wxTextSearch,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_wxTextSearch,
    assign_wxTextSearch,
    SIP_NULLPTR,
    copy_wxTextSearch,
    release_wxTextSearch,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    sizeof (::wxTextSearch),
};
