/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.15.1
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"
        #include <wx/dc.h>
    #include <wx/setup.h>
    #include <wxPython/wxpy_api.h>
        #include <wx/gdicmn.h>
        #include <wx/graphics.h>
        #include <wx/bitmap.h>
        #include <wx/gdicmn.h>
        #include <wx/palette.h>
        #include <wx/colour.h>
        #include <wx/pen.h>
        #include "arrayholder.h"
        #include <wx/brush.h>
        #include <wx/region.h>
        #include <wx/gdicmn.h>
        #include <wx/icon.h>
        #include <wx/font.h>
        #include <wx/dc.h>
        #include <wx/affinematrix2d.h>
        #include <wx/object.h>
        #include <wx/object.h>
        #include <wx/object.h>
        //--------------------------------------------------------------------------
        // Name:        src/dc_ex.h
        // Purpose:     Functions that can quickly draw lists of items on a DC
        //
        // Author:      Robin Dunn
        //
        // Created:     18-Aug-2012
        // Copyright:   (c) 2012-2020 by Total Control Software
        // Licence:     wxWindows license
        //--------------------------------------------------------------------------
        
        typedef bool (*wxPyDrawListOp_t)(wxDC& dc, PyObject* coords);
        
        PyObject* wxPyDrawXXXList(wxDC& dc, wxPyDrawListOp_t doDraw,
                                  PyObject* pyCoords, PyObject* pyPens, PyObject* pyBrushes);
        
        bool wxPyDrawXXXPoint(wxDC& dc, PyObject* coords);
        bool wxPyDrawXXXLine(wxDC& dc, PyObject* coords);
        bool wxPyDrawXXXRectangle(wxDC& dc, PyObject* coords);
        bool wxPyDrawXXXEllipse(wxDC& dc, PyObject* coords);
        bool wxPyDrawXXXPolygon(wxDC& dc, PyObject* coords);
        
        PyObject* wxPyDrawTextList(wxDC& dc, PyObject* textList, PyObject* pyPoints,
                                   PyObject* foregroundList, PyObject* backgroundList);
        
        //--------------------------------------------------------------------------
        
        
        PyObject* wxPyDrawXXXList(wxDC& dc, wxPyDrawListOp_t doDraw,
                                  PyObject* pyCoords, PyObject* pyPens, PyObject* pyBrushes)
        {
            wxPyBlock_t blocked = wxPyBeginBlockThreads();
        
            bool      isFastSeq  = PyList_Check(pyCoords) || PyTuple_Check(pyCoords);
            bool      isFastPens = PyList_Check(pyPens) || PyTuple_Check(pyPens);
            bool      isFastBrushes = PyList_Check(pyBrushes) || PyTuple_Check(pyBrushes);
            int       numObjs = 0;
            int       numPens = 0;
            int       numBrushes = 0;
            wxPen*    pen;
            wxBrush*  brush;
            PyObject* obj;
            PyObject* coords;
            int       i = 0;
            PyObject* retval;
        
            if (!PySequence_Check(pyCoords)) {
                goto err0;
            }
            if (!PySequence_Check(pyPens)) {
                goto err1;
            }
            if (!PySequence_Check(pyBrushes)) {
                goto err2;
            }
            numObjs = PySequence_Length(pyCoords);
            numPens = PySequence_Length(pyPens);
            numBrushes = PySequence_Length(pyBrushes);
            for (i = 0; i < numObjs; i++) {
                // Use a new pen?
                if (i < numPens) {
                    if (isFastPens) {
                        obj = PySequence_Fast_GET_ITEM(pyPens, i);
                    }
                    else {
                        obj = PySequence_GetItem(pyPens, i);
                    }
                    if (! wxPyConvertWrappedPtr(obj, (void **) &pen, "wxPen")) {
                        if (!isFastPens)
                            Py_DECREF(obj);
                        goto err1;
                    }
        
                    dc.SetPen(*pen);
                    if (!isFastPens)
                        Py_DECREF(obj);
                }
                // Use a new brush?
                if (i < numBrushes) {
                    if (isFastBrushes) {
                        obj = PySequence_Fast_GET_ITEM(pyBrushes, i);
                    }
                    else {
                        obj = PySequence_GetItem(pyBrushes, i);
                    }
                    if (!wxPyConvertWrappedPtr(obj, (void **) &brush, "wxBrush")) {
                        if (!isFastBrushes)
                            Py_DECREF(obj);
                        goto err2;
                    }
        
                    dc.SetBrush(*brush);
                    if (!isFastBrushes)
                        Py_DECREF(obj);
                }
        
                // Get the Coordinates
                if (isFastSeq) {
                    coords = PySequence_Fast_GET_ITEM(pyCoords, i);
                }
                else {
                    coords = PySequence_GetItem(pyCoords, i);
                }
        
        
                // call the drawOp
                bool success = doDraw(dc, coords);
                if (!isFastSeq)
                    Py_DECREF(coords);
        
                if (! success) {
                    retval = NULL;
                    goto exit;
                }
        
            } // end of main for loop
        
            Py_INCREF(Py_None);
            retval = Py_None;
            goto exit;
        
        
         err0:
            PyErr_SetString(PyExc_TypeError, "Expected a sequence of coordinates");
            retval = NULL;
            goto exit;
        
         err1:
            PyErr_SetString(PyExc_TypeError, "Expected a sequence of wxPens");
            retval = NULL;
            goto exit;
        
         err2:
            PyErr_SetString(PyExc_TypeError, "Expected a sequence of wxBrushes");
            retval = NULL;
            goto exit;
        
        
         exit:
            wxPyEndBlockThreads(blocked);
            return retval;
        }
        
        
        
        bool wxPyDrawXXXPoint(wxDC& dc, PyObject* coords)
        {
            int x, y;
        
            if (! wxPy2int_seq_helper(coords, &x, &y)) {
                PyErr_SetString(PyExc_TypeError, "Expected a sequence of (x,y) sequences.");
                return false;
            }
            dc.DrawPoint(x, y);
            return true;
        }
        
        bool wxPyDrawXXXLine(wxDC& dc, PyObject* coords)
        {
            int x1, y1, x2, y2;
        
            if (! wxPy4int_seq_helper(coords, &x1, &y1, &x2, &y2)) {
                PyErr_SetString(PyExc_TypeError, "Expected a sequence of (x1,y1, x1,y2) sequences.");
                return false;
            }
            dc.DrawLine(x1,y1, x2,y2);
            return true;
        }
        
        bool wxPyDrawXXXRectangle(wxDC& dc, PyObject* coords)
        {
            int x, y, w, h;
        
            if (! wxPy4int_seq_helper(coords, &x, &y, &w, &h)) {
                PyErr_SetString(PyExc_TypeError, "Expected a sequence of (x,y, w,h) sequences.");
                return false;
            }
            dc.DrawRectangle(x, y, w, h);
            return true;
        }
        
        bool wxPyDrawXXXEllipse(wxDC& dc, PyObject* coords)
        {
            int x, y, w, h;
        
            if (! wxPy4int_seq_helper(coords, &x, &y, &w, &h)) {
                PyErr_SetString(PyExc_TypeError, "Expected a sequence of (x,y, w,h) sequences.");
                return false;
            }
            dc.DrawEllipse(x, y, w, h);
            return true;
        }
        
        
        wxPoint* wxPoint_LIST_helper(PyObject* source, int *count);
        
        bool wxPyDrawXXXPolygon(wxDC& dc, PyObject* coords)
        {
            wxPoint* points;
            int numPoints;
        
            points = wxPoint_LIST_helper(coords, &numPoints);
            if (! points) {
                PyErr_SetString(PyExc_TypeError, "Expected a sequence of sequences of (x,y) sequences.");
                return false;
            }
            dc.DrawPolygon(numPoints, points);
            delete [] points;
            return true;
        }
        
        
        //---------------------------------------------------------------------------
        
        
        
        PyObject* wxPyDrawTextList(wxDC& dc, PyObject* textList, PyObject* pyPoints, PyObject* foregroundList, PyObject* backgroundList)
        {
            wxPyBlock_t blocked = wxPyBeginBlockThreads();
        
            bool      isFastSeq  = PyList_Check(pyPoints) || PyTuple_Check(pyPoints);
            bool      isFastText = PyList_Check(textList) || PyTuple_Check(textList);
            bool      isFastForeground = PyList_Check(foregroundList) || PyTuple_Check(foregroundList);
            bool      isFastBackground = PyList_Check(backgroundList) || PyTuple_Check(backgroundList);
            int       numText = 0;
            int       numPoints = 0;
            int       numForeground = 0;
            int       numBackground = 0;
            PyObject* obj;
            int       x1, y1;
            int       i = 0;
            wxColor*    color;
            PyObject* retval;
            wxString  string;
        
            if (!PySequence_Check(pyPoints)) {
                goto err0;
            }
            if (!PySequence_Check(textList)) {
                goto err1;
            }
            if (!PySequence_Check(foregroundList)) {
                goto err2;
            }
            if (!PySequence_Check(backgroundList)) {
                goto err3;
            }
            numPoints = PySequence_Length(pyPoints);
            numText = PySequence_Length(textList);
            numForeground = PySequence_Length(foregroundList);
            numBackground = PySequence_Length(backgroundList);
        
            for (i = 0; i < numPoints; i++) {
                // Use a new string ?
                if (i < numText) {
                    if ( isFastText ) {
                        obj = PySequence_Fast_GET_ITEM(textList, i);
                    }
                    else {
                        obj = PySequence_GetItem(textList, i);
                    }
                    if (! PyBytes_Check(obj) && !PyUnicode_Check(obj) ) {
                        Py_DECREF(obj);
                        goto err1;
                    }
                    string = Py2wxString(obj);
                    if ( !isFastText )
                        Py_DECREF(obj);
                }
        
                if (i < numForeground) {
                    // Use a new foreground ?
                    if ( isFastForeground ) {
                        obj = PySequence_Fast_GET_ITEM(foregroundList, i);
                    }
                    else {
                        obj = PySequence_GetItem(foregroundList, i);
                    }
                    if (! wxPyConvertWrappedPtr(obj, (void **) &color, "wxColour")) {
                        if (!isFastForeground)
                            Py_DECREF(obj);
                        goto err2;
                    }
                    dc.SetTextForeground(*color);
                    if ( !isFastForeground )
                        Py_DECREF(obj);
                }
        
                if (i < numBackground) {
                    // Use a new background ?
                    if ( isFastBackground ) {
                        obj = PySequence_Fast_GET_ITEM(backgroundList, i);
                    }
                    else {
                        obj = PySequence_GetItem(backgroundList, i);
                    }
                    if (! wxPyConvertWrappedPtr(obj, (void **) &color, "wxColour")) {
                        if (!isFastBackground)
                            Py_DECREF(obj);
                        goto err3;
                    }
                    dc.SetTextBackground(*color);
                    if ( !isFastBackground )
                        Py_DECREF(obj);
                }
        
                // Get the point coordinates
                if (isFastSeq) {
                    obj = PySequence_Fast_GET_ITEM(pyPoints, i);
                }
                else {
                    obj = PySequence_GetItem(pyPoints, i);
                }
                if (! wxPy2int_seq_helper(obj, &x1, &y1)) {
                    if (! isFastSeq)
                        Py_DECREF(obj);
                    goto err0;
                }
                if (!isFastText)
                    Py_DECREF(obj);
        
                if (PyErr_Occurred()) {
                    retval = NULL;
                    goto exit;
                }
        
                // Now draw the text
                dc.DrawText(string, x1, y1);
            }
        
            Py_INCREF(Py_None);
            retval = Py_None;
            goto exit;
        
         err0:
            PyErr_SetString(PyExc_TypeError, "Expected a sequence of (x,y) sequences.");
            retval = NULL;
            goto exit;
         err1:
            PyErr_SetString(PyExc_TypeError, "Expected a sequence of strings");
            retval = NULL;
            goto exit;
        
         err2:
            PyErr_SetString(PyExc_TypeError, "Expected a sequence of wxColours for foregrounds");
            retval = NULL;
            goto exit;
        
         err3:
            PyErr_SetString(PyExc_TypeError, "Expected a sequence of wxColours for backgrounds");
            retval = NULL;
            goto exit;
        
         exit:
            wxPyEndBlockThreads(blocked);
            return retval;
        }
        
        //---------------------------------------------------------------------------
        
        
        bool wxPointFromObjects(PyObject* o1, PyObject* o2, wxPoint* point)
        {
            // get the x value
            if (wxPyInt_Check(o1))
                point->x = (int)wxPyInt_AS_LONG(o1);
            else if (PyFloat_Check(o1))
                point->x = (int)PyFloat_AS_DOUBLE(o1);
            else if (PyNumber_Check(o1))
                point->x = (int)wxPyInt_AsLong(o1);
            else
                return false;
        
            // get the y value
            if (wxPyInt_Check(o2))
                point->y = (int)wxPyInt_AS_LONG(o2);
            else if (PyFloat_Check(o2))
                point->y = (int)PyFloat_AS_DOUBLE(o2);
            else if (PyNumber_Check(o2))
                point->y = (int)wxPyInt_AsLong(o2);
            else
                return false;
        
            return true;
        }
        
        
        wxPoint* wxPoint_LIST_helper(PyObject* source, int *count)
        {
            int idx;
            wxPoint* temp;
            PyObject *o, *o1, *o2;
            bool isFast = PyList_Check(source) || PyTuple_Check(source);
        
            if (!PySequence_Check(source)) {
                goto error0;
            }
        
            // The length of the sequence is returned in count.
            *count = PySequence_Length(source);
            if (*count < 0) {
                goto error0;
            }
        
            temp = new wxPoint[*count];
            if (!temp) {
                PyErr_SetString(PyExc_MemoryError, "Unable to allocate temporary array");
                return NULL;
            }
            for (idx=0; idx<*count; idx++) {
                // Get an item: try fast way first.
                if (isFast) {
                    o = PySequence_Fast_GET_ITEM(source, idx);
                }
                else {
                    o = PySequence_GetItem(source, idx);
                    if (o == NULL) {
                        goto error1;
                    }
                }
        
                // Convert o to wxPoint.
                if ((PyTuple_Check(o) && PyTuple_GET_SIZE(o) == 2) ||
                    (PyList_Check(o) && PyList_GET_SIZE(o) == 2)) {
                    o1 = PySequence_Fast_GET_ITEM(o, 0);
                    o2 = PySequence_Fast_GET_ITEM(o, 1);
                    if (!wxPointFromObjects(o1, o2, &temp[idx])) {
                        goto error2;
                    }
                }
                else if (wxPyWrappedPtr_Check(o)) {
                    wxPoint* pt;
                    if (! wxPyConvertWrappedPtr(o, (void **)&pt, "wxPoint")) {
                        goto error2;
                    }
                    temp[idx] = *pt;
                }
                else if (PySequence_Check(o) && PySequence_Length(o) == 2) {
                    o1 = PySequence_GetItem(o, 0);
                    o2 = PySequence_GetItem(o, 1);
                    if (!wxPointFromObjects(o1, o2, &temp[idx])) {
                        goto error3;
                    }
                    Py_DECREF(o1);
                    Py_DECREF(o2);
                }
                else {
                    goto error2;
                }
                // Clean up.
                if (!isFast)
                    Py_DECREF(o);
            }
            return temp;
        
        error3:
            Py_DECREF(o1);
            Py_DECREF(o2);
        error2:
            if (!isFast)
                Py_DECREF(o);
        error1:
            delete [] temp;
        error0:
            PyErr_SetString(PyExc_TypeError, "Expected a sequence of length-2 sequences or wx.Points.");
            return NULL;
        }
        
        
        PyObject* wxPyDrawLinesFromBuffer(wxDC& dc, PyObject* pyBuff)
        {
            wxPyBlock_t blocked = wxPyBeginBlockThreads();
            Py_buffer view;
            PyObject* retval;
        
        
            if (!PyObject_CheckBuffer(pyBuff)) {
                goto err0;
            }
            
            if (PyObject_GetBuffer(pyBuff, &view, PyBUF_CONTIG) < 0) {
                goto err1;
            }
            
            if (view.itemsize * 2 != sizeof(wxPoint)) {
                goto err2;
            }
            
            dc.DrawLines(view.len / view.itemsize / 2, (wxPoint *)view.buf);
            
            PyBuffer_Release(&view);
        
            Py_INCREF(Py_None);
            retval = Py_None;
            goto exit;
        
        
         err0:
            PyErr_SetString(PyExc_TypeError, "Expected a buffer object");
            retval = NULL;
            goto exit;
            
         err1:
            // PyObject_GetBuffer raises exception already
            retval = NULL;
            goto exit;
        
         err2:
            PyErr_SetString(PyExc_TypeError, "Item size does not match wxPoint size");
            retval = NULL;
            goto exit;
        
         exit:
            wxPyEndBlockThreads(blocked);
            return retval;
        }
    wxRect* _wxDC_DrawLabel(wxDC* self, const wxString *text, const wxBitmap *bitmap, const wxRect *rect, int alignment, int indexAccel)
    {
        wxRect rv;
        self->DrawLabel(*text, *bitmap, *rect, alignment, indexAccel, &rv);
        return new wxRect(rv);
    }
    wxColour* _wxDC_GetPixel(wxDC* self, wxCoord x, wxCoord y)
    {
        wxColour* col = new wxColour;
        self->GetPixel(x, y, col);
        return col;
    }
    wxUIntPtr* _wxDC_GetHandle(const wxDC* self)
    {
        return new wxUIntPtr((wxUIntPtr)self->GetHandle());
    }
    wxSize* _wxDC_GetTextExtent(const wxDC* self, const wxString* st)
    {
        return new wxSize(self->GetTextExtent(*st));
    }
    wxSize* _wxDC_GetMultiLineTextExtent(const wxDC* self, const wxString* st)
    {
        return new wxSize(self->GetMultiLineTextExtent(*st));
    }
    int _wxDC___nonzero__(wxDC* self)
    {
        return self->IsOk();
    }
    int _wxDC___bool__(wxDC* self)
    {
        return self->IsOk();
    }
    long _wxDC_GetHDC(wxDC* self)
    {
        #ifdef __WXMSW__
            return HandleToLong(self->GetHandle());
        #else
            wxPyRaiseNotImplemented();
            return 0;
        #endif
    }
    wxUIntPtr* _wxDC_GetCGContext(wxDC* self)
    {
        #ifdef __WXMAC__
            return new wxUIntPtr((wxUIntPtr)self->GetHandle());
        #else
            wxPyRaiseNotImplemented();
            return NULL;
        #endif
    }
    wxUIntPtr* _wxDC_GetGdkDrawable(wxDC* self)
    {
        #ifdef __WXGTK__
            return new wxUIntPtr((wxUIntPtr)self->GetHandle());
        #else
            wxPyRaiseNotImplemented();
            return NULL;
        #endif
    }
    PyObject* _wxDC__DrawPointList(wxDC* self, PyObject* pyCoords, PyObject* pyPens, PyObject* pyBrushes)
    {
        return wxPyDrawXXXList(*self, wxPyDrawXXXPoint, pyCoords, pyPens, pyBrushes);
    }
    PyObject* _wxDC__DrawLineList(wxDC* self, PyObject* pyCoords, PyObject* pyPens, PyObject* pyBrushes)
    {
        return wxPyDrawXXXList(*self, wxPyDrawXXXLine, pyCoords, pyPens, pyBrushes);
    }
    PyObject* _wxDC__DrawRectangleList(wxDC* self, PyObject* pyCoords, PyObject* pyPens, PyObject* pyBrushes)
    {
        return wxPyDrawXXXList(*self, wxPyDrawXXXRectangle, pyCoords, pyPens, pyBrushes);
    }
    PyObject* _wxDC__DrawEllipseList(wxDC* self, PyObject* pyCoords, PyObject* pyPens, PyObject* pyBrushes)
    {
        return wxPyDrawXXXList(*self, wxPyDrawXXXEllipse, pyCoords, pyPens, pyBrushes);
    }
    PyObject* _wxDC__DrawPolygonList(wxDC* self, PyObject* pyCoords, PyObject* pyPens, PyObject* pyBrushes)
    {
        return wxPyDrawXXXList(*self, wxPyDrawXXXPolygon, pyCoords, pyPens, pyBrushes);
    }
    PyObject* _wxDC__DrawTextList(wxDC* self, PyObject* textList, PyObject* pyPoints, PyObject* foregroundList, PyObject* backgroundList)
    {
        return wxPyDrawTextList(*self, textList, pyPoints, foregroundList, backgroundList);
    }
    PyObject* _wxDC__DrawLinesFromBuffer(wxDC* self, PyObject* pyBuff)
    {
        return wxPyDrawLinesFromBuffer(*self, pyBuff);
    }


PyDoc_STRVAR(doc_wxDC_Clear, "Clear() -> None\n"
"\n"
"Clears the device context using the current background brush.");

extern "C" {static PyObject *meth_wxDC_Clear(PyObject *, PyObject *);}
static PyObject *meth_wxDC_Clear(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxDC *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDC, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->Clear();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_DC, sipName_Clear, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDC_DrawArc, "DrawArc(xStart, yStart, xEnd, yEnd, xc, yc) -> None\n"
"DrawArc(ptStart, ptEnd, centre) -> None\n"
"\n"
"Draws an arc from the given start to the given end point.\n"
"");

extern "C" {static PyObject *meth_wxDC_DrawArc(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC_DrawArc(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxCoord xStart;
        ::wxCoord yStart;
        ::wxCoord xEnd;
        ::wxCoord yEnd;
        ::wxCoord xc;
        ::wxCoord yc;
        ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_xStart,
            sipName_yStart,
            sipName_xEnd,
            sipName_yEnd,
            sipName_xc,
            sipName_yc,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Biiiiii", &sipSelf, sipType_wxDC, &sipCpp, &xStart, &yStart, &xEnd, &yEnd, &xc, &yc))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawArc(xStart, yStart, xEnd, yEnd, xc, yc);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const ::wxPoint* ptStart;
        int ptStartState = 0;
        const ::wxPoint* ptEnd;
        int ptEndState = 0;
        const ::wxPoint* centre;
        int centreState = 0;
        ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_ptStart,
            sipName_ptEnd,
            sipName_centre,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1J1J1", &sipSelf, sipType_wxDC, &sipCpp, sipType_wxPoint, &ptStart, &ptStartState, sipType_wxPoint, &ptEnd, &ptEndState, sipType_wxPoint, &centre, &centreState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawArc(*ptStart, *ptEnd, *centre);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPoint *>(ptStart), sipType_wxPoint, ptStartState);
            sipReleaseType(const_cast< ::wxPoint *>(ptEnd), sipType_wxPoint, ptEndState);
            sipReleaseType(const_cast< ::wxPoint *>(centre), sipType_wxPoint, centreState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_DC, sipName_DrawArc, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDC_DrawBitmap, "DrawBitmap(bitmap, x, y, useMask=False) -> None\n"
"DrawBitmap(bmp, pt, useMask=False) -> None\n"
"\n"
"Draw a bitmap on the device context at the specified point.\n"
"");

extern "C" {static PyObject *meth_wxDC_DrawBitmap(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC_DrawBitmap(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxBitmap* bitmap;
        ::wxCoord x;
        ::wxCoord y;
        bool useMask = 0;
        ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_bitmap,
            sipName_x,
            sipName_y,
            sipName_useMask,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9ii|b", &sipSelf, sipType_wxDC, &sipCpp, sipType_wxBitmap, &bitmap, &x, &y, &useMask))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawBitmap(*bitmap, x, y, useMask);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const ::wxBitmap* bmp;
        const ::wxPoint* pt;
        int ptState = 0;
        bool useMask = 0;
        ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_bmp,
            sipName_pt,
            sipName_useMask,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9J1|b", &sipSelf, sipType_wxDC, &sipCpp, sipType_wxBitmap, &bmp, sipType_wxPoint, &pt, &ptState, &useMask))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawBitmap(*bmp, *pt, useMask);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPoint *>(pt), sipType_wxPoint, ptState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_DC, sipName_DrawBitmap, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDC_DrawCheckMark, "DrawCheckMark(x, y, width, height) -> None\n"
"DrawCheckMark(rect) -> None\n"
"\n"
"Draws a check mark inside the given rectangle.\n"
"");

extern "C" {static PyObject *meth_wxDC_DrawCheckMark(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC_DrawCheckMark(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxCoord x;
        ::wxCoord y;
        ::wxCoord width;
        ::wxCoord height;
        ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
            sipName_width,
            sipName_height,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Biiii", &sipSelf, sipType_wxDC, &sipCpp, &x, &y, &width, &height))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawCheckMark(x, y, width, height);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const ::wxRect* rect;
        int rectState = 0;
        ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_rect,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxDC, &sipCpp, sipType_wxRect, &rect, &rectState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawCheckMark(*rect);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxRect *>(rect), sipType_wxRect, rectState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_DC, sipName_DrawCheckMark, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDC_DrawCircle, "DrawCircle(x, y, radius) -> None\n"
"DrawCircle(pt, radius) -> None\n"
"\n"
"Draws a circle with the given centre and radius.\n"
"");

extern "C" {static PyObject *meth_wxDC_DrawCircle(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC_DrawCircle(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxCoord x;
        ::wxCoord y;
        ::wxCoord radius;
        ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
            sipName_radius,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Biii", &sipSelf, sipType_wxDC, &sipCpp, &x, &y, &radius))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawCircle(x, y, radius);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const ::wxPoint* pt;
        int ptState = 0;
        ::wxCoord radius;
        ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_pt,
            sipName_radius,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1i", &sipSelf, sipType_wxDC, &sipCpp, sipType_wxPoint, &pt, &ptState, &radius))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawCircle(*pt, radius);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPoint *>(pt), sipType_wxPoint, ptState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_DC, sipName_DrawCircle, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDC_DrawEllipse, "DrawEllipse(x, y, width, height) -> None\n"
"DrawEllipse(pt, size) -> None\n"
"DrawEllipse(rect) -> None\n"
"\n"
"Draws an ellipse contained in the rectangle specified either with the\n"
"given top left corner and the given size or directly.\n"
"\n"
"");

extern "C" {static PyObject *meth_wxDC_DrawEllipse(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC_DrawEllipse(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxCoord x;
        ::wxCoord y;
        ::wxCoord width;
        ::wxCoord height;
        ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
            sipName_width,
            sipName_height,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Biiii", &sipSelf, sipType_wxDC, &sipCpp, &x, &y, &width, &height))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawEllipse(x, y, width, height);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const ::wxPoint* pt;
        int ptState = 0;
        const ::wxSize* size;
        int sizeState = 0;
        ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_pt,
            sipName_size,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1J1", &sipSelf, sipType_wxDC, &sipCpp, sipType_wxPoint, &pt, &ptState, sipType_wxSize, &size, &sizeState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawEllipse(*pt, *size);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPoint *>(pt), sipType_wxPoint, ptState);
            sipReleaseType(const_cast< ::wxSize *>(size), sipType_wxSize, sizeState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const ::wxRect* rect;
        int rectState = 0;
        ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_rect,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxDC, &sipCpp, sipType_wxRect, &rect, &rectState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawEllipse(*rect);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxRect *>(rect), sipType_wxRect, rectState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_DC, sipName_DrawEllipse, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDC_DrawEllipticArc, "DrawEllipticArc(x, y, width, height, start, end) -> None\n"
"DrawEllipticArc(pt, sz, sa, ea) -> None\n"
"\n"
"Draws an arc of an ellipse.\n"
"");

extern "C" {static PyObject *meth_wxDC_DrawEllipticArc(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC_DrawEllipticArc(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxCoord x;
        ::wxCoord y;
        ::wxCoord width;
        ::wxCoord height;
        double start;
        double end;
        ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
            sipName_width,
            sipName_height,
            sipName_start,
            sipName_end,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Biiiidd", &sipSelf, sipType_wxDC, &sipCpp, &x, &y, &width, &height, &start, &end))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawEllipticArc(x, y, width, height, start, end);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const ::wxPoint* pt;
        int ptState = 0;
        const ::wxSize* sz;
        int szState = 0;
        double sa;
        double ea;
        ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_pt,
            sipName_sz,
            sipName_sa,
            sipName_ea,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1J1dd", &sipSelf, sipType_wxDC, &sipCpp, sipType_wxPoint, &pt, &ptState, sipType_wxSize, &sz, &szState, &sa, &ea))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawEllipticArc(*pt, *sz, sa, ea);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPoint *>(pt), sipType_wxPoint, ptState);
            sipReleaseType(const_cast< ::wxSize *>(sz), sipType_wxSize, szState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_DC, sipName_DrawEllipticArc, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDC_DrawIcon, "DrawIcon(icon, x, y) -> None\n"
"DrawIcon(icon, pt) -> None\n"
"\n"
"Draw an icon on the display (does nothing if the device context is\n"
"PostScript).\n"
"");

extern "C" {static PyObject *meth_wxDC_DrawIcon(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC_DrawIcon(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxIcon* icon;
        ::wxCoord x;
        ::wxCoord y;
        ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_icon,
            sipName_x,
            sipName_y,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9ii", &sipSelf, sipType_wxDC, &sipCpp, sipType_wxIcon, &icon, &x, &y))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawIcon(*icon, x, y);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const ::wxIcon* icon;
        const ::wxPoint* pt;
        int ptState = 0;
        ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_icon,
            sipName_pt,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9J1", &sipSelf, sipType_wxDC, &sipCpp, sipType_wxIcon, &icon, sipType_wxPoint, &pt, &ptState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawIcon(*icon, *pt);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPoint *>(pt), sipType_wxPoint, ptState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_DC, sipName_DrawIcon, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDC_DrawLabel, "DrawLabel(text, bitmap, rect, alignment=ALIGN_LEFT|ALIGN_TOP, indexAccel=-1) -> Rect\n"
"DrawLabel(text, rect, alignment=ALIGN_LEFT|ALIGN_TOP, indexAccel=-1) -> None\n"
"\n"
"Draw optional bitmap and the text into the given rectangle and aligns\n"
"it as specified by alignment parameter; it also will emphasize the\n"
"character with the given index if it is != -1 and return the bounding\n"
"rectangle if required.\n"
"DrawLabel(text, rect, alignment=ALIGN_LEFT|ALIGN_TOP, indexAccel=-1) -> None\n"
"\n"
"This is an overloaded member function, provided for convenience. It\n"
"differs from the above function only in what argument(s) it accepts.");

extern "C" {static PyObject *meth_wxDC_DrawLabel(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC_DrawLabel(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxString* text;
        int textState = 0;
        const ::wxBitmap* bitmap;
        const ::wxRect* rect;
        int rectState = 0;
        int alignment = wxALIGN_LEFT|wxALIGN_TOP;
        int indexAccel = -1;
        ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_text,
            sipName_bitmap,
            sipName_rect,
            sipName_alignment,
            sipName_indexAccel,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1J9J1|ii", &sipSelf, sipType_wxDC, &sipCpp, sipType_wxString, &text, &textState, sipType_wxBitmap, &bitmap, sipType_wxRect, &rect, &rectState, &alignment, &indexAccel))
        {
            ::wxRect*sipRes = 0;
            int sipIsErr = 0;
        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxDC_DrawLabel(sipCpp, text, bitmap, rect, alignment, indexAccel);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;
            sipReleaseType(const_cast< ::wxString *>(text), sipType_wxString, textState);
            sipReleaseType(const_cast< ::wxRect *>(rect), sipType_wxRect, rectState);

            if (sipIsErr)
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxRect, SIP_NULLPTR);
        }
    }

    {
        const ::wxString* text;
        int textState = 0;
        const ::wxRect* rect;
        int rectState = 0;
        int alignment = wxALIGN_LEFT|wxALIGN_TOP;
        int indexAccel = -1;
        ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_text,
            sipName_rect,
            sipName_alignment,
            sipName_indexAccel,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1J1|ii", &sipSelf, sipType_wxDC, &sipCpp, sipType_wxString, &text, &textState, sipType_wxRect, &rect, &rectState, &alignment, &indexAccel))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawLabel(*text, *rect, alignment, indexAccel);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(text), sipType_wxString, textState);
            sipReleaseType(const_cast< ::wxRect *>(rect), sipType_wxRect, rectState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_DC, sipName_DrawLabel, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDC_DrawLine, "DrawLine(x1, y1, x2, y2) -> None\n"
"DrawLine(pt1, pt2) -> None\n"
"\n"
"Draws a line from the first point to the second.\n"
"");

extern "C" {static PyObject *meth_wxDC_DrawLine(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC_DrawLine(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxCoord x1;
        ::wxCoord y1;
        ::wxCoord x2;
        ::wxCoord y2;
        ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x1,
            sipName_y1,
            sipName_x2,
            sipName_y2,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Biiii", &sipSelf, sipType_wxDC, &sipCpp, &x1, &y1, &x2, &y2))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawLine(x1, y1, x2, y2);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const ::wxPoint* pt1;
        int pt1State = 0;
        const ::wxPoint* pt2;
        int pt2State = 0;
        ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_pt1,
            sipName_pt2,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1J1", &sipSelf, sipType_wxDC, &sipCpp, sipType_wxPoint, &pt1, &pt1State, sipType_wxPoint, &pt2, &pt2State))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawLine(*pt1, *pt2);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPoint *>(pt1), sipType_wxPoint, pt1State);
            sipReleaseType(const_cast< ::wxPoint *>(pt2), sipType_wxPoint, pt2State);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_DC, sipName_DrawLine, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDC_DrawLines, "DrawLines(points, xoffset=0, yoffset=0) -> None\n"
"\n"
"This method uses a list of wxPoints, adding the optional offset\n"
"coordinate.");

extern "C" {static PyObject *meth_wxDC_DrawLines(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC_DrawLines(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxPointList* points;
        int pointsState = 0;
        ::wxCoord xoffset = 0;
        ::wxCoord yoffset = 0;
        ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_points,
            sipName_xoffset,
            sipName_yoffset,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ0|ii", &sipSelf, sipType_wxDC, &sipCpp, sipType_wxPointList, &points, &pointsState, &xoffset, &yoffset))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawLines(points, xoffset, yoffset);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPointList *>(points), sipType_wxPointList, pointsState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_DC, sipName_DrawLines, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDC_DrawPoint, "DrawPoint(x, y) -> None\n"
"DrawPoint(pt) -> None\n"
"\n"
"Draws a point using the color of the current pen.\n"
"");

extern "C" {static PyObject *meth_wxDC_DrawPoint(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC_DrawPoint(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxCoord x;
        ::wxCoord y;
        ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bii", &sipSelf, sipType_wxDC, &sipCpp, &x, &y))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawPoint(x, y);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const ::wxPoint* pt;
        int ptState = 0;
        ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_pt,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxDC, &sipCpp, sipType_wxPoint, &pt, &ptState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawPoint(*pt);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPoint *>(pt), sipType_wxPoint, ptState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_DC, sipName_DrawPoint, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDC_DrawPolygon, "DrawPolygon(points, xoffset=0, yoffset=0, fill_style=ODDEVEN_RULE) -> None\n"
"\n"
"This method draws a filled polygon using a list of wxPoints, adding\n"
"the optional offset coordinate.");

extern "C" {static PyObject *meth_wxDC_DrawPolygon(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC_DrawPolygon(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxPointList* points;
        int pointsState = 0;
        ::wxCoord xoffset = 0;
        ::wxCoord yoffset = 0;
        ::wxPolygonFillMode fill_style = wxODDEVEN_RULE;
        ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_points,
            sipName_xoffset,
            sipName_yoffset,
            sipName_fill_style,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ0|iiE", &sipSelf, sipType_wxDC, &sipCpp, sipType_wxPointList, &points, &pointsState, &xoffset, &yoffset, sipType_wxPolygonFillMode, &fill_style))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawPolygon(points, xoffset, yoffset, fill_style);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPointList *>(points), sipType_wxPointList, pointsState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_DC, sipName_DrawPolygon, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDC_DrawRectangle, "DrawRectangle(x, y, width, height) -> None\n"
"DrawRectangle(pt, sz) -> None\n"
"DrawRectangle(rect) -> None\n"
"\n"
"Draws a rectangle with the given corner coordinate and size.\n"
"\n"
"");

extern "C" {static PyObject *meth_wxDC_DrawRectangle(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC_DrawRectangle(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxCoord x;
        ::wxCoord y;
        ::wxCoord width;
        ::wxCoord height;
        ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
            sipName_width,
            sipName_height,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Biiii", &sipSelf, sipType_wxDC, &sipCpp, &x, &y, &width, &height))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawRectangle(x, y, width, height);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const ::wxPoint* pt;
        int ptState = 0;
        const ::wxSize* sz;
        int szState = 0;
        ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_pt,
            sipName_sz,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1J1", &sipSelf, sipType_wxDC, &sipCpp, sipType_wxPoint, &pt, &ptState, sipType_wxSize, &sz, &szState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawRectangle(*pt, *sz);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPoint *>(pt), sipType_wxPoint, ptState);
            sipReleaseType(const_cast< ::wxSize *>(sz), sipType_wxSize, szState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const ::wxRect* rect;
        int rectState = 0;
        ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_rect,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxDC, &sipCpp, sipType_wxRect, &rect, &rectState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawRectangle(*rect);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxRect *>(rect), sipType_wxRect, rectState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_DC, sipName_DrawRectangle, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDC_DrawRotatedText, "DrawRotatedText(text, x, y, angle) -> None\n"
"DrawRotatedText(text, point, angle) -> None\n"
"\n"
"Draws the text rotated by angle degrees (positive angles are\n"
"counterclockwise; the full angle is 360 degrees).\n"
"");

extern "C" {static PyObject *meth_wxDC_DrawRotatedText(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC_DrawRotatedText(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxString* text;
        int textState = 0;
        ::wxCoord x;
        ::wxCoord y;
        double angle;
        ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_text,
            sipName_x,
            sipName_y,
            sipName_angle,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1iid", &sipSelf, sipType_wxDC, &sipCpp, sipType_wxString, &text, &textState, &x, &y, &angle))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawRotatedText(*text, x, y, angle);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(text), sipType_wxString, textState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const ::wxString* text;
        int textState = 0;
        const ::wxPoint* point;
        int pointState = 0;
        double angle;
        ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_text,
            sipName_point,
            sipName_angle,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1J1d", &sipSelf, sipType_wxDC, &sipCpp, sipType_wxString, &text, &textState, sipType_wxPoint, &point, &pointState, &angle))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawRotatedText(*text, *point, angle);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(text), sipType_wxString, textState);
            sipReleaseType(const_cast< ::wxPoint *>(point), sipType_wxPoint, pointState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_DC, sipName_DrawRotatedText, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDC_DrawRoundedRectangle, "DrawRoundedRectangle(x, y, width, height, radius) -> None\n"
"DrawRoundedRectangle(pt, sz, radius) -> None\n"
"DrawRoundedRectangle(rect, radius) -> None\n"
"\n"
"Draws a rectangle with the given top left corner, and with the given\n"
"size.\n"
"\n"
"");

extern "C" {static PyObject *meth_wxDC_DrawRoundedRectangle(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC_DrawRoundedRectangle(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxCoord x;
        ::wxCoord y;
        ::wxCoord width;
        ::wxCoord height;
        double radius;
        ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
            sipName_width,
            sipName_height,
            sipName_radius,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Biiiid", &sipSelf, sipType_wxDC, &sipCpp, &x, &y, &width, &height, &radius))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawRoundedRectangle(x, y, width, height, radius);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const ::wxPoint* pt;
        int ptState = 0;
        const ::wxSize* sz;
        int szState = 0;
        double radius;
        ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_pt,
            sipName_sz,
            sipName_radius,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1J1d", &sipSelf, sipType_wxDC, &sipCpp, sipType_wxPoint, &pt, &ptState, sipType_wxSize, &sz, &szState, &radius))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawRoundedRectangle(*pt, *sz, radius);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPoint *>(pt), sipType_wxPoint, ptState);
            sipReleaseType(const_cast< ::wxSize *>(sz), sipType_wxSize, szState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const ::wxRect* rect;
        int rectState = 0;
        double radius;
        ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_rect,
            sipName_radius,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1d", &sipSelf, sipType_wxDC, &sipCpp, sipType_wxRect, &rect, &rectState, &radius))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawRoundedRectangle(*rect, radius);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxRect *>(rect), sipType_wxRect, rectState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_DC, sipName_DrawRoundedRectangle, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDC_DrawSpline, "DrawSpline(points) -> None\n"
"DrawSpline(x1, y1, x2, y2, x3, y3) -> None\n"
"\n"
"This is an overloaded member function, provided for convenience. It\n"
"differs from the above function only in what argument(s) it accepts.\n"
"");

extern "C" {static PyObject *meth_wxDC_DrawSpline(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC_DrawSpline(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxPointList* points;
        int pointsState = 0;
        ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_points,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ0", &sipSelf, sipType_wxDC, &sipCpp, sipType_wxPointList, &points, &pointsState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawSpline(points);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPointList *>(points), sipType_wxPointList, pointsState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        ::wxCoord x1;
        ::wxCoord y1;
        ::wxCoord x2;
        ::wxCoord y2;
        ::wxCoord x3;
        ::wxCoord y3;
        ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x1,
            sipName_y1,
            sipName_x2,
            sipName_y2,
            sipName_x3,
            sipName_y3,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Biiiiii", &sipSelf, sipType_wxDC, &sipCpp, &x1, &y1, &x2, &y2, &x3, &y3))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawSpline(x1, y1, x2, y2, x3, y3);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_DC, sipName_DrawSpline, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDC_DrawText, "DrawText(text, x, y) -> None\n"
"DrawText(text, pt) -> None\n"
"\n"
"Draws a text string at the specified point, using the current text\n"
"font, and the current text foreground and background colours.\n"
"");

extern "C" {static PyObject *meth_wxDC_DrawText(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC_DrawText(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxString* text;
        int textState = 0;
        ::wxCoord x;
        ::wxCoord y;
        ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_text,
            sipName_x,
            sipName_y,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1ii", &sipSelf, sipType_wxDC, &sipCpp, sipType_wxString, &text, &textState, &x, &y))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawText(*text, x, y);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(text), sipType_wxString, textState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const ::wxString* text;
        int textState = 0;
        const ::wxPoint* pt;
        int ptState = 0;
        ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_text,
            sipName_pt,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1J1", &sipSelf, sipType_wxDC, &sipCpp, sipType_wxString, &text, &textState, sipType_wxPoint, &pt, &ptState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawText(*text, *pt);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(text), sipType_wxString, textState);
            sipReleaseType(const_cast< ::wxPoint *>(pt), sipType_wxPoint, ptState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_DC, sipName_DrawText, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDC_GradientFillConcentric, "GradientFillConcentric(rect, initialColour, destColour) -> None\n"
"GradientFillConcentric(rect, initialColour, destColour, circleCenter) -> None\n"
"\n"
"Fill the area specified by rect with a radial gradient, starting from\n"
"initialColour at the centre of the circle and fading to destColour on\n"
"the circle outside.\n"
"");

extern "C" {static PyObject *meth_wxDC_GradientFillConcentric(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC_GradientFillConcentric(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxRect* rect;
        int rectState = 0;
        const ::wxColour* initialColour;
        int initialColourState = 0;
        const ::wxColour* destColour;
        int destColourState = 0;
        ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_rect,
            sipName_initialColour,
            sipName_destColour,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1J1J1", &sipSelf, sipType_wxDC, &sipCpp, sipType_wxRect, &rect, &rectState, sipType_wxColour, &initialColour, &initialColourState, sipType_wxColour, &destColour, &destColourState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->GradientFillConcentric(*rect, *initialColour, *destColour);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxRect *>(rect), sipType_wxRect, rectState);
            sipReleaseType(const_cast< ::wxColour *>(initialColour), sipType_wxColour, initialColourState);
            sipReleaseType(const_cast< ::wxColour *>(destColour), sipType_wxColour, destColourState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const ::wxRect* rect;
        int rectState = 0;
        const ::wxColour* initialColour;
        int initialColourState = 0;
        const ::wxColour* destColour;
        int destColourState = 0;
        const ::wxPoint* circleCenter;
        int circleCenterState = 0;
        ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_rect,
            sipName_initialColour,
            sipName_destColour,
            sipName_circleCenter,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1J1J1J1", &sipSelf, sipType_wxDC, &sipCpp, sipType_wxRect, &rect, &rectState, sipType_wxColour, &initialColour, &initialColourState, sipType_wxColour, &destColour, &destColourState, sipType_wxPoint, &circleCenter, &circleCenterState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->GradientFillConcentric(*rect, *initialColour, *destColour, *circleCenter);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxRect *>(rect), sipType_wxRect, rectState);
            sipReleaseType(const_cast< ::wxColour *>(initialColour), sipType_wxColour, initialColourState);
            sipReleaseType(const_cast< ::wxColour *>(destColour), sipType_wxColour, destColourState);
            sipReleaseType(const_cast< ::wxPoint *>(circleCenter), sipType_wxPoint, circleCenterState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_DC, sipName_GradientFillConcentric, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDC_GradientFillLinear, "GradientFillLinear(rect, initialColour, destColour, nDirection=RIGHT) -> None\n"
"\n"
"Fill the area specified by rect with a linear gradient, starting from\n"
"initialColour and eventually fading to destColour.");

extern "C" {static PyObject *meth_wxDC_GradientFillLinear(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC_GradientFillLinear(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxRect* rect;
        int rectState = 0;
        const ::wxColour* initialColour;
        int initialColourState = 0;
        const ::wxColour* destColour;
        int destColourState = 0;
        ::wxDirection nDirection = wxRIGHT;
        ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_rect,
            sipName_initialColour,
            sipName_destColour,
            sipName_nDirection,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1J1J1|E", &sipSelf, sipType_wxDC, &sipCpp, sipType_wxRect, &rect, &rectState, sipType_wxColour, &initialColour, &initialColourState, sipType_wxColour, &destColour, &destColourState, sipType_wxDirection, &nDirection))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->GradientFillLinear(*rect, *initialColour, *destColour, nDirection);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxRect *>(rect), sipType_wxRect, rectState);
            sipReleaseType(const_cast< ::wxColour *>(initialColour), sipType_wxColour, initialColourState);
            sipReleaseType(const_cast< ::wxColour *>(destColour), sipType_wxColour, destColourState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_DC, sipName_GradientFillLinear, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDC_FloodFill, "FloodFill(x, y, colour, style=FLOOD_SURFACE) -> bool\n"
"FloodFill(pt, col, style=FLOOD_SURFACE) -> bool\n"
"\n"
"Flood fills the device context starting from the given point, using\n"
"the current brush colour, and using a style:\n"
"");

extern "C" {static PyObject *meth_wxDC_FloodFill(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC_FloodFill(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxCoord x;
        ::wxCoord y;
        const ::wxColour* colour;
        int colourState = 0;
        ::wxFloodFillStyle style = wxFLOOD_SURFACE;
        ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
            sipName_colour,
            sipName_style,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BiiJ1|E", &sipSelf, sipType_wxDC, &sipCpp, &x, &y, sipType_wxColour, &colour, &colourState, sipType_wxFloodFillStyle, &style))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->FloodFill(x, y, *colour, style);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxColour *>(colour), sipType_wxColour, colourState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    {
        const ::wxPoint* pt;
        int ptState = 0;
        const ::wxColour* col;
        int colState = 0;
        ::wxFloodFillStyle style = wxFLOOD_SURFACE;
        ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_pt,
            sipName_col,
            sipName_style,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1J1|E", &sipSelf, sipType_wxDC, &sipCpp, sipType_wxPoint, &pt, &ptState, sipType_wxColour, &col, &colState, sipType_wxFloodFillStyle, &style))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->FloodFill(*pt, *col, style);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPoint *>(pt), sipType_wxPoint, ptState);
            sipReleaseType(const_cast< ::wxColour *>(col), sipType_wxColour, colState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_DC, sipName_FloodFill, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDC_CrossHair, "CrossHair(x, y) -> None\n"
"CrossHair(pt) -> None\n"
"\n"
"Displays a cross hair using the current pen.\n"
"");

extern "C" {static PyObject *meth_wxDC_CrossHair(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC_CrossHair(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxCoord x;
        ::wxCoord y;
        ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bii", &sipSelf, sipType_wxDC, &sipCpp, &x, &y))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->CrossHair(x, y);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const ::wxPoint* pt;
        int ptState = 0;
        ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_pt,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxDC, &sipCpp, sipType_wxPoint, &pt, &ptState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->CrossHair(*pt);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPoint *>(pt), sipType_wxPoint, ptState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_DC, sipName_CrossHair, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDC_DestroyClippingRegion, "DestroyClippingRegion() -> None\n"
"\n"
"Destroys the current clipping region so that none of the DC is\n"
"clipped.");

extern "C" {static PyObject *meth_wxDC_DestroyClippingRegion(PyObject *, PyObject *);}
static PyObject *meth_wxDC_DestroyClippingRegion(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxDC *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDC, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DestroyClippingRegion();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_DC, sipName_DestroyClippingRegion, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDC_GetClippingBox, "GetClippingBox() -> Tuple[bool, int, int, int, int]\n"
"\n"
"Gets the rectangle surrounding the current clipping region.");

extern "C" {static PyObject *meth_wxDC_GetClippingBox(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC_GetClippingBox(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxCoord x;
        ::wxCoord y;
        ::wxCoord width;
        ::wxCoord height;
        const ::wxDC *sipCpp;

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, SIP_NULLPTR, "B", &sipSelf, sipType_wxDC, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetClippingBox(&x, &y, &width, &height);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipBuildResult(0, "(biiii)", sipRes, x, y, width, height);
        }
    }

    sipNoMethod(sipParseErr, sipName_DC, sipName_GetClippingBox, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDC_SetClippingRegion, "SetClippingRegion(x, y, width, height) -> None\n"
"SetClippingRegion(pt, sz) -> None\n"
"SetClippingRegion(rect) -> None\n"
"\n"
"Sets the clipping region for this device context to the intersection\n"
"of the given region described by the parameters of this method and the\n"
"previously set clipping region.\n"
"\n"
"");

extern "C" {static PyObject *meth_wxDC_SetClippingRegion(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC_SetClippingRegion(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxCoord x;
        ::wxCoord y;
        ::wxCoord width;
        ::wxCoord height;
        ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
            sipName_width,
            sipName_height,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Biiii", &sipSelf, sipType_wxDC, &sipCpp, &x, &y, &width, &height))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetClippingRegion(x, y, width, height);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const ::wxPoint* pt;
        int ptState = 0;
        const ::wxSize* sz;
        int szState = 0;
        ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_pt,
            sipName_sz,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1J1", &sipSelf, sipType_wxDC, &sipCpp, sipType_wxPoint, &pt, &ptState, sipType_wxSize, &sz, &szState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetClippingRegion(*pt, *sz);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPoint *>(pt), sipType_wxPoint, ptState);
            sipReleaseType(const_cast< ::wxSize *>(sz), sipType_wxSize, szState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const ::wxRect* rect;
        int rectState = 0;
        ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_rect,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxDC, &sipCpp, sipType_wxRect, &rect, &rectState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetClippingRegion(*rect);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxRect *>(rect), sipType_wxRect, rectState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_DC, sipName_SetClippingRegion, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDC_SetDeviceClippingRegion, "SetDeviceClippingRegion(region) -> None\n"
"\n"
"Sets the clipping region for this device context.");

extern "C" {static PyObject *meth_wxDC_SetDeviceClippingRegion(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC_SetDeviceClippingRegion(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxRegion* region;
        ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_region,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxDC, &sipCpp, sipType_wxRegion, &region))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetDeviceClippingRegion(*region);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_DC, sipName_SetDeviceClippingRegion, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDC_GetBackgroundMode, "GetBackgroundMode() -> int\n"
"\n"
"Returns the current background mode: wxBRUSHSTYLE_SOLID or\n"
"wxBRUSHSTYLE_TRANSPARENT.");

extern "C" {static PyObject *meth_wxDC_GetBackgroundMode(PyObject *, PyObject *);}
static PyObject *meth_wxDC_GetBackgroundMode(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxDC *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDC, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetBackgroundMode();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_DC, sipName_GetBackgroundMode, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDC_GetTextBackground, "GetTextBackground() -> Colour\n"
"\n"
"Gets the current text background colour.");

extern "C" {static PyObject *meth_wxDC_GetTextBackground(PyObject *, PyObject *);}
static PyObject *meth_wxDC_GetTextBackground(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxDC *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDC, &sipCpp))
        {
            ::wxColour*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxColour(sipCpp->GetTextBackground());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxColour, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_DC, sipName_GetTextBackground, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDC_GetTextForeground, "GetTextForeground() -> Colour\n"
"\n"
"Gets the current text foreground colour.");

extern "C" {static PyObject *meth_wxDC_GetTextForeground(PyObject *, PyObject *);}
static PyObject *meth_wxDC_GetTextForeground(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxDC *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDC, &sipCpp))
        {
            ::wxColour*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxColour(sipCpp->GetTextForeground());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxColour, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_DC, sipName_GetTextForeground, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDC_SetBackgroundMode, "SetBackgroundMode(mode) -> None\n"
"\n"
"Change the current background mode.");

extern "C" {static PyObject *meth_wxDC_SetBackgroundMode(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC_SetBackgroundMode(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int mode;
        ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_mode,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxDC, &sipCpp, &mode))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetBackgroundMode(mode);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_DC, sipName_SetBackgroundMode, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDC_SetTextBackground, "SetTextBackground(colour) -> None\n"
"\n"
"Sets the current text background colour for the DC.");

extern "C" {static PyObject *meth_wxDC_SetTextBackground(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC_SetTextBackground(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxColour* colour;
        int colourState = 0;
        ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_colour,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxDC, &sipCpp, sipType_wxColour, &colour, &colourState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetTextBackground(*colour);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxColour *>(colour), sipType_wxColour, colourState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_DC, sipName_SetTextBackground, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDC_SetTextForeground, "SetTextForeground(colour) -> None\n"
"\n"
"Sets the current text foreground colour for the DC.");

extern "C" {static PyObject *meth_wxDC_SetTextForeground(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC_SetTextForeground(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxColour* colour;
        int colourState = 0;
        ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_colour,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxDC, &sipCpp, sipType_wxColour, &colour, &colourState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetTextForeground(*colour);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxColour *>(colour), sipType_wxColour, colourState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_DC, sipName_SetTextForeground, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDC_DisableAutomaticBoundingBoxUpdates, "DisableAutomaticBoundingBoxUpdates() -> None\n"
"\n"
"Disable automatic bounding box updates.");

extern "C" {static PyObject *meth_wxDC_DisableAutomaticBoundingBoxUpdates(PyObject *, PyObject *);}
static PyObject *meth_wxDC_DisableAutomaticBoundingBoxUpdates(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxDC *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDC, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DisableAutomaticBoundingBoxUpdates();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_DC, sipName_DisableAutomaticBoundingBoxUpdates, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDC_AreAutomaticBoundingBoxUpdatesEnabled, "AreAutomaticBoundingBoxUpdatesEnabled() -> bool\n"
"\n"
"Check if automatic bounding box updates are performed.");

extern "C" {static PyObject *meth_wxDC_AreAutomaticBoundingBoxUpdatesEnabled(PyObject *, PyObject *);}
static PyObject *meth_wxDC_AreAutomaticBoundingBoxUpdatesEnabled(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxDC *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDC, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->AreAutomaticBoundingBoxUpdatesEnabled();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_DC, sipName_AreAutomaticBoundingBoxUpdatesEnabled, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDC_CalcBoundingBox, "CalcBoundingBox(x, y) -> None\n"
"\n"
"Adds the specified point to the bounding box which can be retrieved\n"
"with MinX(), MaxX() and MinY(), MaxY() functions.");

extern "C" {static PyObject *meth_wxDC_CalcBoundingBox(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC_CalcBoundingBox(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxCoord x;
        ::wxCoord y;
        ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bii", &sipSelf, sipType_wxDC, &sipCpp, &x, &y))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->CalcBoundingBox(x, y);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_DC, sipName_CalcBoundingBox, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDC_MaxX, "MaxX() -> int\n"
"\n"
"Gets the maximum horizontal extent used in drawing commands so far.");

extern "C" {static PyObject *meth_wxDC_MaxX(PyObject *, PyObject *);}
static PyObject *meth_wxDC_MaxX(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxDC *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDC, &sipCpp))
        {
            ::wxCoord sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->MaxX();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_DC, sipName_MaxX, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDC_MaxY, "MaxY() -> int\n"
"\n"
"Gets the maximum vertical extent used in drawing commands so far.");

extern "C" {static PyObject *meth_wxDC_MaxY(PyObject *, PyObject *);}
static PyObject *meth_wxDC_MaxY(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxDC *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDC, &sipCpp))
        {
            ::wxCoord sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->MaxY();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_DC, sipName_MaxY, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDC_MinX, "MinX() -> int\n"
"\n"
"Gets the minimum horizontal extent used in drawing commands so far.");

extern "C" {static PyObject *meth_wxDC_MinX(PyObject *, PyObject *);}
static PyObject *meth_wxDC_MinX(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxDC *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDC, &sipCpp))
        {
            ::wxCoord sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->MinX();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_DC, sipName_MinX, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDC_MinY, "MinY() -> int\n"
"\n"
"Gets the minimum vertical extent used in drawing commands so far.");

extern "C" {static PyObject *meth_wxDC_MinY(PyObject *, PyObject *);}
static PyObject *meth_wxDC_MinY(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxDC *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDC, &sipCpp))
        {
            ::wxCoord sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->MinY();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_DC, sipName_MinY, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDC_ResetBoundingBox, "ResetBoundingBox() -> None\n"
"\n"
"Resets the bounding box: after a call to this function, the bounding\n"
"box doesn't contain anything.");

extern "C" {static PyObject *meth_wxDC_ResetBoundingBox(PyObject *, PyObject *);}
static PyObject *meth_wxDC_ResetBoundingBox(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxDC *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDC, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->ResetBoundingBox();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_DC, sipName_ResetBoundingBox, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDC_StartDoc, "StartDoc(message) -> bool\n"
"\n"
"Starts a document (only relevant when outputting to a printer).");

extern "C" {static PyObject *meth_wxDC_StartDoc(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC_StartDoc(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxString* message;
        int messageState = 0;
        ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_message,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxDC, &sipCpp, sipType_wxString, &message, &messageState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->StartDoc(*message);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(message), sipType_wxString, messageState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_DC, sipName_StartDoc, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDC_StartPage, "StartPage() -> None\n"
"\n"
"Starts a document page (only relevant when outputting to a printer).");

extern "C" {static PyObject *meth_wxDC_StartPage(PyObject *, PyObject *);}
static PyObject *meth_wxDC_StartPage(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxDC *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDC, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->StartPage();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_DC, sipName_StartPage, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDC_EndDoc, "EndDoc() -> None\n"
"\n"
"Ends a document (only relevant when outputting to a printer).");

extern "C" {static PyObject *meth_wxDC_EndDoc(PyObject *, PyObject *);}
static PyObject *meth_wxDC_EndDoc(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxDC *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDC, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->EndDoc();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_DC, sipName_EndDoc, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDC_EndPage, "EndPage() -> None\n"
"\n"
"Ends a document page (only relevant when outputting to a printer).");

extern "C" {static PyObject *meth_wxDC_EndPage(PyObject *, PyObject *);}
static PyObject *meth_wxDC_EndPage(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxDC *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDC, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->EndPage();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_DC, sipName_EndPage, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDC_Blit, "Blit(xdest, ydest, width, height, source, xsrc, ysrc, logicalFunc=COPY, useMask=False, xsrcMask=DefaultCoord, ysrcMask=DefaultCoord) -> bool\n"
"\n"
"Copy from a source DC to this DC.");

extern "C" {static PyObject *meth_wxDC_Blit(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC_Blit(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxCoord xdest;
        ::wxCoord ydest;
        ::wxCoord width;
        ::wxCoord height;
        ::wxDC* source;
        ::wxCoord xsrc;
        ::wxCoord ysrc;
        ::wxRasterOperationMode logicalFunc = wxCOPY;
        bool useMask = 0;
        ::wxCoord xsrcMask = wxDefaultCoord;
        ::wxCoord ysrcMask = wxDefaultCoord;
        ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_xdest,
            sipName_ydest,
            sipName_width,
            sipName_height,
            sipName_source,
            sipName_xsrc,
            sipName_ysrc,
            sipName_logicalFunc,
            sipName_useMask,
            sipName_xsrcMask,
            sipName_ysrcMask,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BiiiiJ8ii|Ebii", &sipSelf, sipType_wxDC, &sipCpp, &xdest, &ydest, &width, &height, sipType_wxDC, &source, &xsrc, &ysrc, sipType_wxRasterOperationMode, &logicalFunc, &useMask, &xsrcMask, &ysrcMask))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Blit(xdest, ydest, width, height, source, xsrc, ysrc, logicalFunc, useMask, xsrcMask, ysrcMask);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_DC, sipName_Blit, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDC_StretchBlit, "StretchBlit(xdest, ydest, dstWidth, dstHeight, source, xsrc, ysrc, srcWidth, srcHeight, logicalFunc=COPY, useMask=False, xsrcMask=DefaultCoord, ysrcMask=DefaultCoord) -> bool\n"
"\n"
"Copy from a source DC to this DC possibly changing the scale.");

extern "C" {static PyObject *meth_wxDC_StretchBlit(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC_StretchBlit(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxCoord xdest;
        ::wxCoord ydest;
        ::wxCoord dstWidth;
        ::wxCoord dstHeight;
        ::wxDC* source;
        ::wxCoord xsrc;
        ::wxCoord ysrc;
        ::wxCoord srcWidth;
        ::wxCoord srcHeight;
        ::wxRasterOperationMode logicalFunc = wxCOPY;
        bool useMask = 0;
        ::wxCoord xsrcMask = wxDefaultCoord;
        ::wxCoord ysrcMask = wxDefaultCoord;
        ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_xdest,
            sipName_ydest,
            sipName_dstWidth,
            sipName_dstHeight,
            sipName_source,
            sipName_xsrc,
            sipName_ysrc,
            sipName_srcWidth,
            sipName_srcHeight,
            sipName_logicalFunc,
            sipName_useMask,
            sipName_xsrcMask,
            sipName_ysrcMask,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BiiiiJ8iiii|Ebii", &sipSelf, sipType_wxDC, &sipCpp, &xdest, &ydest, &dstWidth, &dstHeight, sipType_wxDC, &source, &xsrc, &ysrc, &srcWidth, &srcHeight, sipType_wxRasterOperationMode, &logicalFunc, &useMask, &xsrcMask, &ysrcMask))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->StretchBlit(xdest, ydest, dstWidth, dstHeight, source, xsrc, ysrc, srcWidth, srcHeight, logicalFunc, useMask, xsrcMask, ysrcMask);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_DC, sipName_StretchBlit, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDC_GetBackground, "GetBackground() -> Brush\n"
"\n"
"Gets the brush used for painting the background.");

extern "C" {static PyObject *meth_wxDC_GetBackground(PyObject *, PyObject *);}
static PyObject *meth_wxDC_GetBackground(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxDC *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDC, &sipCpp))
        {
            ::wxBrush*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxBrush(sipCpp->GetBackground());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxBrush, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_DC, sipName_GetBackground, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDC_GetBrush, "GetBrush() -> Brush\n"
"\n"
"Gets the current brush.");

extern "C" {static PyObject *meth_wxDC_GetBrush(PyObject *, PyObject *);}
static PyObject *meth_wxDC_GetBrush(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxDC *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDC, &sipCpp))
        {
            ::wxBrush*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxBrush(sipCpp->GetBrush());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxBrush, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_DC, sipName_GetBrush, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDC_GetPen, "GetPen() -> Pen\n"
"\n"
"Gets the current pen.");

extern "C" {static PyObject *meth_wxDC_GetPen(PyObject *, PyObject *);}
static PyObject *meth_wxDC_GetPen(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxDC *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDC, &sipCpp))
        {
            ::wxPen*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxPen(sipCpp->GetPen());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxPen, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_DC, sipName_GetPen, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDC_SetBackground, "SetBackground(brush) -> None\n"
"\n"
"Sets the current background brush for the DC.");

extern "C" {static PyObject *meth_wxDC_SetBackground(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC_SetBackground(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxBrush* brush;
        ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_brush,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxDC, &sipCpp, sipType_wxBrush, &brush))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetBackground(*brush);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_DC, sipName_SetBackground, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDC_SetBrush, "SetBrush(brush) -> None\n"
"\n"
"Sets the current brush for the DC.");

extern "C" {static PyObject *meth_wxDC_SetBrush(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC_SetBrush(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxBrush* brush;
        ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_brush,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxDC, &sipCpp, sipType_wxBrush, &brush))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetBrush(*brush);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_DC, sipName_SetBrush, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDC_SetPen, "SetPen(pen) -> None\n"
"\n"
"Sets the current pen for the DC.");

extern "C" {static PyObject *meth_wxDC_SetPen(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC_SetPen(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxPen* pen;
        ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_pen,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxDC, &sipCpp, sipType_wxPen, &pen))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetPen(*pen);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_DC, sipName_SetPen, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDC_GetLogicalFunction, "GetLogicalFunction() -> RasterOperationMode\n"
"\n"
"Gets the current logical function.");

extern "C" {static PyObject *meth_wxDC_GetLogicalFunction(PyObject *, PyObject *);}
static PyObject *meth_wxDC_GetLogicalFunction(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxDC *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDC, &sipCpp))
        {
            ::wxRasterOperationMode sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetLogicalFunction();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_wxRasterOperationMode);
        }
    }

    sipNoMethod(sipParseErr, sipName_DC, sipName_GetLogicalFunction, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDC_GetPixel, "GetPixel(x, y) -> Colour\n"
"\n"
"Gets the colour at the specified location on the DC.\n"
"\n"
"This method isn't available for ``wx.PostScriptDC`` or\n"
"``wx.MetafileDC`` nor\n"
"for any DC in wxOSX port, and simply returns ``wx.NullColour`` there.\n"
"\n"
".. note:: Setting a pixel can be done using DrawPoint().\n"
"\n"
".. note:: This method shouldn't be used with ``wx.PaintDC`` as\n"
"accessing the\n"
"          DC while drawing can result in unexpected results, notably\n"
"in wxGTK.");

extern "C" {static PyObject *meth_wxDC_GetPixel(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC_GetPixel(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxCoord x;
        ::wxCoord y;
        ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bii", &sipSelf, sipType_wxDC, &sipCpp, &x, &y))
        {
            ::wxColour*sipRes = 0;
            int sipIsErr = 0;
        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxDC_GetPixel(sipCpp, x, y);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxColour, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_DC, sipName_GetPixel, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDC_SetLogicalFunction, "SetLogicalFunction(function) -> None\n"
"\n"
"Sets the current logical function for the device context.");

extern "C" {static PyObject *meth_wxDC_SetLogicalFunction(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC_SetLogicalFunction(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxRasterOperationMode function;
        ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_function,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BE", &sipSelf, sipType_wxDC, &sipCpp, sipType_wxRasterOperationMode, &function))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetLogicalFunction(function);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_DC, sipName_SetLogicalFunction, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDC_SetPalette, "SetPalette(palette) -> None\n"
"\n"
"If this is a window DC or memory DC, assigns the given palette to the\n"
"window or bitmap associated with the DC.");

extern "C" {static PyObject *meth_wxDC_SetPalette(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC_SetPalette(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxPalette* palette;
        ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_palette,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxDC, &sipCpp, sipType_wxPalette, &palette))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetPalette(*palette);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_DC, sipName_SetPalette, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDC_CopyAttributes, "CopyAttributes(dc) -> None\n"
"\n"
"Copy attributes from another DC.");

extern "C" {static PyObject *meth_wxDC_CopyAttributes(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC_CopyAttributes(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxDC* dc;
        ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_dc,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxDC, &sipCpp, sipType_wxDC, &dc))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->CopyAttributes(*dc);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_DC, sipName_CopyAttributes, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDC_GetHandle, "GetHandle() -> UIntPtr\n"
"\n"
"Returns a value that can be used as a handle to the native drawing\n"
"context, if this wxDC has something that could be thought of in that\n"
"way.");

extern "C" {static PyObject *meth_wxDC_GetHandle(PyObject *, PyObject *);}
static PyObject *meth_wxDC_GetHandle(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxDC *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDC, &sipCpp))
        {
            ::wxUIntPtr*sipRes = 0;
            int sipIsErr = 0;
        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxDC_GetHandle(sipCpp);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            return sipConvertFromType(sipRes, sipType_wxUIntPtr, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_DC, sipName_GetHandle, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDC_GetAsBitmap, "GetAsBitmap(subrect=nullptr) -> Bitmap\n"
"\n"
"If supported by the platform and the type of DC, fetch the contents of\n"
"the DC, or a subset of it, as a bitmap.");

extern "C" {static PyObject *meth_wxDC_GetAsBitmap(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC_GetAsBitmap(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxRect* subrect = nullptr;
        int subrectState = 0;
        const ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_subrect,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|J0", &sipSelf, sipType_wxDC, &sipCpp, sipType_wxRect, &subrect, &subrectState))
        {
            ::wxBitmap*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxBitmap(sipCpp->GetAsBitmap(subrect));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxRect *>(subrect), sipType_wxRect, subrectState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxBitmap, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_DC, sipName_GetAsBitmap, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDC_GetGraphicsContext, "GetGraphicsContext() -> GraphicsContext\n"
"\n"
"If supported by the platform and the wxDC implementation, this method\n"
"will return the wxGraphicsContext associated with the DC.");

extern "C" {static PyObject *meth_wxDC_GetGraphicsContext(PyObject *, PyObject *);}
static PyObject *meth_wxDC_GetGraphicsContext(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxDC *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDC, &sipCpp))
        {
            ::wxGraphicsContext*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetGraphicsContext();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes, sipType_wxGraphicsContext, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_DC, sipName_GetGraphicsContext, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDC_SetGraphicsContext, "SetGraphicsContext(ctx) -> None\n"
"\n"
"Associate a wxGraphicsContext with the DC.");

extern "C" {static PyObject *meth_wxDC_SetGraphicsContext(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC_SetGraphicsContext(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxGraphicsContext* ctx;
        ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_ctx,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ8", &sipSelf, sipType_wxDC, &sipCpp, sipType_wxGraphicsContext, &ctx))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetGraphicsContext(ctx);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_DC, sipName_SetGraphicsContext, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDC_GetTextExtent, "GetTextExtent(st) -> Size\n"
"\n"
"Return the dimensions of the given string's text extent using the\n"
"currently selected font.\n"
"\n"
":param st: The string to be measured\n"
"\n"
".. seealso:: :meth:`~wx.DC.GetFullTextExtent`");

extern "C" {static PyObject *meth_wxDC_GetTextExtent(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC_GetTextExtent(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxString* st;
        int stState = 0;
        const ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_st,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxDC, &sipCpp, sipType_wxString, &st, &stState))
        {
            ::wxSize*sipRes = 0;
            int sipIsErr = 0;
        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxDC_GetTextExtent(sipCpp, st);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;
            sipReleaseType(const_cast< ::wxString *>(st), sipType_wxString, stState);

            if (sipIsErr)
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxSize, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_DC, sipName_GetTextExtent, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDC_GetMultiLineTextExtent, "GetMultiLineTextExtent(st) -> Size\n"
"\n"
"Return the dimensions of the given string's text extent using the\n"
"currently selected font, taking into account multiple lines if\n"
"present in the string.\n"
"\n"
":param st: The string to be measured\n"
"\n"
".. seealso:: :meth:`~wx.DC.GetFullMultiLineTextExtent`");

extern "C" {static PyObject *meth_wxDC_GetMultiLineTextExtent(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC_GetMultiLineTextExtent(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxString* st;
        int stState = 0;
        const ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_st,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxDC, &sipCpp, sipType_wxString, &st, &stState))
        {
            ::wxSize*sipRes = 0;
            int sipIsErr = 0;
        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxDC_GetMultiLineTextExtent(sipCpp, st);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;
            sipReleaseType(const_cast< ::wxString *>(st), sipType_wxString, stState);

            if (sipIsErr)
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxSize, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_DC, sipName_GetMultiLineTextExtent, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDC___nonzero__, "__nonzero__() -> bool");

extern "C" {static PyObject *meth_wxDC___nonzero__(PyObject *, PyObject *);}
static PyObject *meth_wxDC___nonzero__(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxDC *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDC, &sipCpp))
        {
            int sipRes = 0;
            int sipIsErr = 0;
        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxDC___nonzero__(sipCpp);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_DC, sipName___nonzero__, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDC_GetHDC, "GetHDC() -> int");

extern "C" {static PyObject *meth_wxDC_GetHDC(PyObject *, PyObject *);}
static PyObject *meth_wxDC_GetHDC(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxDC *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDC, &sipCpp))
        {
            long sipRes = 0;
            int sipIsErr = 0;
        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxDC_GetHDC(sipCpp);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_DC, sipName_GetHDC, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDC_GetCGContext, "GetCGContext() -> UIntPtr");

extern "C" {static PyObject *meth_wxDC_GetCGContext(PyObject *, PyObject *);}
static PyObject *meth_wxDC_GetCGContext(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxDC *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDC, &sipCpp))
        {
            ::wxUIntPtr*sipRes = 0;
            int sipIsErr = 0;
        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxDC_GetCGContext(sipCpp);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            return sipConvertFromType(sipRes, sipType_wxUIntPtr, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_DC, sipName_GetCGContext, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDC_GetGdkDrawable, "GetGdkDrawable() -> UIntPtr");

extern "C" {static PyObject *meth_wxDC_GetGdkDrawable(PyObject *, PyObject *);}
static PyObject *meth_wxDC_GetGdkDrawable(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxDC *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxDC, &sipCpp))
        {
            ::wxUIntPtr*sipRes = 0;
            int sipIsErr = 0;
        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxDC_GetGdkDrawable(sipCpp);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            return sipConvertFromType(sipRes, sipType_wxUIntPtr, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_DC, sipName_GetGdkDrawable, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDC__DrawPointList, "_DrawPointList(pyCoords, pyPens, pyBrushes) -> Any");

extern "C" {static PyObject *meth_wxDC__DrawPointList(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC__DrawPointList(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        PyObject * pyCoords;
        PyObject * pyPens;
        PyObject * pyBrushes;
        ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_pyCoords,
            sipName_pyPens,
            sipName_pyBrushes,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BP0P0P0", &sipSelf, sipType_wxDC, &sipCpp, &pyCoords, &pyPens, &pyBrushes))
        {
            PyObject * sipRes = SIP_NULLPTR;
            int sipIsErr = 0;
        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxDC__DrawPointList(sipCpp, pyCoords, pyPens, pyBrushes);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            return sipRes;
        }
    }

    sipNoMethod(sipParseErr, sipName_DC, sipName__DrawPointList, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDC__DrawLineList, "_DrawLineList(pyCoords, pyPens, pyBrushes) -> Any");

extern "C" {static PyObject *meth_wxDC__DrawLineList(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC__DrawLineList(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        PyObject * pyCoords;
        PyObject * pyPens;
        PyObject * pyBrushes;
        ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_pyCoords,
            sipName_pyPens,
            sipName_pyBrushes,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BP0P0P0", &sipSelf, sipType_wxDC, &sipCpp, &pyCoords, &pyPens, &pyBrushes))
        {
            PyObject * sipRes = SIP_NULLPTR;
            int sipIsErr = 0;
        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxDC__DrawLineList(sipCpp, pyCoords, pyPens, pyBrushes);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            return sipRes;
        }
    }

    sipNoMethod(sipParseErr, sipName_DC, sipName__DrawLineList, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDC__DrawRectangleList, "_DrawRectangleList(pyCoords, pyPens, pyBrushes) -> Any");

extern "C" {static PyObject *meth_wxDC__DrawRectangleList(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC__DrawRectangleList(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        PyObject * pyCoords;
        PyObject * pyPens;
        PyObject * pyBrushes;
        ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_pyCoords,
            sipName_pyPens,
            sipName_pyBrushes,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BP0P0P0", &sipSelf, sipType_wxDC, &sipCpp, &pyCoords, &pyPens, &pyBrushes))
        {
            PyObject * sipRes = SIP_NULLPTR;
            int sipIsErr = 0;
        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxDC__DrawRectangleList(sipCpp, pyCoords, pyPens, pyBrushes);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            return sipRes;
        }
    }

    sipNoMethod(sipParseErr, sipName_DC, sipName__DrawRectangleList, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDC__DrawEllipseList, "_DrawEllipseList(pyCoords, pyPens, pyBrushes) -> Any");

extern "C" {static PyObject *meth_wxDC__DrawEllipseList(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC__DrawEllipseList(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        PyObject * pyCoords;
        PyObject * pyPens;
        PyObject * pyBrushes;
        ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_pyCoords,
            sipName_pyPens,
            sipName_pyBrushes,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BP0P0P0", &sipSelf, sipType_wxDC, &sipCpp, &pyCoords, &pyPens, &pyBrushes))
        {
            PyObject * sipRes = SIP_NULLPTR;
            int sipIsErr = 0;
        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxDC__DrawEllipseList(sipCpp, pyCoords, pyPens, pyBrushes);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            return sipRes;
        }
    }

    sipNoMethod(sipParseErr, sipName_DC, sipName__DrawEllipseList, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDC__DrawPolygonList, "_DrawPolygonList(pyCoords, pyPens, pyBrushes) -> Any");

extern "C" {static PyObject *meth_wxDC__DrawPolygonList(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC__DrawPolygonList(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        PyObject * pyCoords;
        PyObject * pyPens;
        PyObject * pyBrushes;
        ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_pyCoords,
            sipName_pyPens,
            sipName_pyBrushes,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BP0P0P0", &sipSelf, sipType_wxDC, &sipCpp, &pyCoords, &pyPens, &pyBrushes))
        {
            PyObject * sipRes = SIP_NULLPTR;
            int sipIsErr = 0;
        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxDC__DrawPolygonList(sipCpp, pyCoords, pyPens, pyBrushes);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            return sipRes;
        }
    }

    sipNoMethod(sipParseErr, sipName_DC, sipName__DrawPolygonList, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDC__DrawTextList, "_DrawTextList(textList, pyPoints, foregroundList, backgroundList) -> Any");

extern "C" {static PyObject *meth_wxDC__DrawTextList(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC__DrawTextList(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        PyObject * textList;
        PyObject * pyPoints;
        PyObject * foregroundList;
        PyObject * backgroundList;
        ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_textList,
            sipName_pyPoints,
            sipName_foregroundList,
            sipName_backgroundList,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BP0P0P0P0", &sipSelf, sipType_wxDC, &sipCpp, &textList, &pyPoints, &foregroundList, &backgroundList))
        {
            PyObject * sipRes = SIP_NULLPTR;
            int sipIsErr = 0;
        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxDC__DrawTextList(sipCpp, textList, pyPoints, foregroundList, backgroundList);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            return sipRes;
        }
    }

    sipNoMethod(sipParseErr, sipName_DC, sipName__DrawTextList, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxDC__DrawLinesFromBuffer, "_DrawLinesFromBuffer(pyBuff) -> Any");

extern "C" {static PyObject *meth_wxDC__DrawLinesFromBuffer(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxDC__DrawLinesFromBuffer(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        PyObject * pyBuff;
        ::wxDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_pyBuff,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BP0", &sipSelf, sipType_wxDC, &sipCpp, &pyBuff))
        {
            PyObject * sipRes = SIP_NULLPTR;
            int sipIsErr = 0;
        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxDC__DrawLinesFromBuffer(sipCpp, pyBuff);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            return sipRes;
        }
    }

    sipNoMethod(sipParseErr, sipName_DC, sipName__DrawLinesFromBuffer, SIP_NULLPTR);

    return SIP_NULLPTR;
}


extern "C" {static int slot_wxDC___bool__(PyObject *);}
static int slot_wxDC___bool__(PyObject *sipSelf)
{
    ::wxDC *sipCpp = reinterpret_cast< ::wxDC *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_wxDC));

    if (!sipCpp)
        return -1;


    {
        {
            int sipRes = 0;
            int sipIsErr = 0;
        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxDC___bool__(sipCpp);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return -1;

            return sipRes;
        }
    }

    return 0;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_wxDC(void *, const sipTypeDef *);}
static void *cast_wxDC(void *sipCppV, const sipTypeDef *targetType)
{
    ::wxDC *sipCpp = reinterpret_cast< ::wxDC *>(sipCppV);

    if (targetType == sipType_wxDC)
        return sipCppV;

    sipCppV = ((const sipClassTypeDef *)sipType_wxReadOnlyDC)->ctd_cast(static_cast< ::wxReadOnlyDC *>(sipCpp), targetType);
    if (sipCppV)
        return sipCppV;

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxDC(void *, int);}
static void release_wxDC(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxDC *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void dealloc_wxDC(sipSimpleWrapper *);}
static void dealloc_wxDC(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxDC(sipGetAddress(sipSelf), 0);
    }
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_wxDC[] = {{482, 255, 1}};


/* Define this type's Python slots. */
static sipPySlotDef slots_wxDC[] = {
    {(void *)slot_wxDC___bool__, bool_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_wxDC[] = {
    {sipName_AreAutomaticBoundingBoxUpdatesEnabled, meth_wxDC_AreAutomaticBoundingBoxUpdatesEnabled, METH_VARARGS, doc_wxDC_AreAutomaticBoundingBoxUpdatesEnabled},
    {sipName_Blit, SIP_MLMETH_CAST(meth_wxDC_Blit), METH_VARARGS|METH_KEYWORDS, doc_wxDC_Blit},
    {sipName_CalcBoundingBox, SIP_MLMETH_CAST(meth_wxDC_CalcBoundingBox), METH_VARARGS|METH_KEYWORDS, doc_wxDC_CalcBoundingBox},
    {sipName_Clear, meth_wxDC_Clear, METH_VARARGS, doc_wxDC_Clear},
    {sipName_CopyAttributes, SIP_MLMETH_CAST(meth_wxDC_CopyAttributes), METH_VARARGS|METH_KEYWORDS, doc_wxDC_CopyAttributes},
    {sipName_CrossHair, SIP_MLMETH_CAST(meth_wxDC_CrossHair), METH_VARARGS|METH_KEYWORDS, doc_wxDC_CrossHair},
    {sipName_DestroyClippingRegion, meth_wxDC_DestroyClippingRegion, METH_VARARGS, doc_wxDC_DestroyClippingRegion},
    {sipName_DisableAutomaticBoundingBoxUpdates, meth_wxDC_DisableAutomaticBoundingBoxUpdates, METH_VARARGS, doc_wxDC_DisableAutomaticBoundingBoxUpdates},
    {sipName_DrawArc, SIP_MLMETH_CAST(meth_wxDC_DrawArc), METH_VARARGS|METH_KEYWORDS, doc_wxDC_DrawArc},
    {sipName_DrawBitmap, SIP_MLMETH_CAST(meth_wxDC_DrawBitmap), METH_VARARGS|METH_KEYWORDS, doc_wxDC_DrawBitmap},
    {sipName_DrawCheckMark, SIP_MLMETH_CAST(meth_wxDC_DrawCheckMark), METH_VARARGS|METH_KEYWORDS, doc_wxDC_DrawCheckMark},
    {sipName_DrawCircle, SIP_MLMETH_CAST(meth_wxDC_DrawCircle), METH_VARARGS|METH_KEYWORDS, doc_wxDC_DrawCircle},
    {sipName_DrawEllipse, SIP_MLMETH_CAST(meth_wxDC_DrawEllipse), METH_VARARGS|METH_KEYWORDS, doc_wxDC_DrawEllipse},
    {sipName_DrawEllipticArc, SIP_MLMETH_CAST(meth_wxDC_DrawEllipticArc), METH_VARARGS|METH_KEYWORDS, doc_wxDC_DrawEllipticArc},
    {sipName_DrawIcon, SIP_MLMETH_CAST(meth_wxDC_DrawIcon), METH_VARARGS|METH_KEYWORDS, doc_wxDC_DrawIcon},
    {sipName_DrawLabel, SIP_MLMETH_CAST(meth_wxDC_DrawLabel), METH_VARARGS|METH_KEYWORDS, doc_wxDC_DrawLabel},
    {sipName_DrawLine, SIP_MLMETH_CAST(meth_wxDC_DrawLine), METH_VARARGS|METH_KEYWORDS, doc_wxDC_DrawLine},
    {sipName_DrawLines, SIP_MLMETH_CAST(meth_wxDC_DrawLines), METH_VARARGS|METH_KEYWORDS, doc_wxDC_DrawLines},
    {sipName_DrawPoint, SIP_MLMETH_CAST(meth_wxDC_DrawPoint), METH_VARARGS|METH_KEYWORDS, doc_wxDC_DrawPoint},
    {sipName_DrawPolygon, SIP_MLMETH_CAST(meth_wxDC_DrawPolygon), METH_VARARGS|METH_KEYWORDS, doc_wxDC_DrawPolygon},
    {sipName_DrawRectangle, SIP_MLMETH_CAST(meth_wxDC_DrawRectangle), METH_VARARGS|METH_KEYWORDS, doc_wxDC_DrawRectangle},
    {sipName_DrawRotatedText, SIP_MLMETH_CAST(meth_wxDC_DrawRotatedText), METH_VARARGS|METH_KEYWORDS, doc_wxDC_DrawRotatedText},
    {sipName_DrawRoundedRectangle, SIP_MLMETH_CAST(meth_wxDC_DrawRoundedRectangle), METH_VARARGS|METH_KEYWORDS, doc_wxDC_DrawRoundedRectangle},
    {sipName_DrawSpline, SIP_MLMETH_CAST(meth_wxDC_DrawSpline), METH_VARARGS|METH_KEYWORDS, doc_wxDC_DrawSpline},
    {sipName_DrawText, SIP_MLMETH_CAST(meth_wxDC_DrawText), METH_VARARGS|METH_KEYWORDS, doc_wxDC_DrawText},
    {sipName_EndDoc, meth_wxDC_EndDoc, METH_VARARGS, doc_wxDC_EndDoc},
    {sipName_EndPage, meth_wxDC_EndPage, METH_VARARGS, doc_wxDC_EndPage},
    {sipName_FloodFill, SIP_MLMETH_CAST(meth_wxDC_FloodFill), METH_VARARGS|METH_KEYWORDS, doc_wxDC_FloodFill},
    {sipName_GetAsBitmap, SIP_MLMETH_CAST(meth_wxDC_GetAsBitmap), METH_VARARGS|METH_KEYWORDS, doc_wxDC_GetAsBitmap},
    {sipName_GetBackground, meth_wxDC_GetBackground, METH_VARARGS, doc_wxDC_GetBackground},
    {sipName_GetBackgroundMode, meth_wxDC_GetBackgroundMode, METH_VARARGS, doc_wxDC_GetBackgroundMode},
    {sipName_GetBrush, meth_wxDC_GetBrush, METH_VARARGS, doc_wxDC_GetBrush},
    {sipName_GetCGContext, meth_wxDC_GetCGContext, METH_VARARGS, doc_wxDC_GetCGContext},
    {sipName_GetClippingBox, SIP_MLMETH_CAST(meth_wxDC_GetClippingBox), METH_VARARGS|METH_KEYWORDS, doc_wxDC_GetClippingBox},
    {sipName_GetGdkDrawable, meth_wxDC_GetGdkDrawable, METH_VARARGS, doc_wxDC_GetGdkDrawable},
    {sipName_GetGraphicsContext, meth_wxDC_GetGraphicsContext, METH_VARARGS, doc_wxDC_GetGraphicsContext},
    {sipName_GetHDC, meth_wxDC_GetHDC, METH_VARARGS, doc_wxDC_GetHDC},
    {sipName_GetHandle, meth_wxDC_GetHandle, METH_VARARGS, doc_wxDC_GetHandle},
    {sipName_GetLogicalFunction, meth_wxDC_GetLogicalFunction, METH_VARARGS, doc_wxDC_GetLogicalFunction},
    {sipName_GetMultiLineTextExtent, SIP_MLMETH_CAST(meth_wxDC_GetMultiLineTextExtent), METH_VARARGS|METH_KEYWORDS, doc_wxDC_GetMultiLineTextExtent},
    {sipName_GetPen, meth_wxDC_GetPen, METH_VARARGS, doc_wxDC_GetPen},
    {sipName_GetPixel, SIP_MLMETH_CAST(meth_wxDC_GetPixel), METH_VARARGS|METH_KEYWORDS, doc_wxDC_GetPixel},
    {sipName_GetTextBackground, meth_wxDC_GetTextBackground, METH_VARARGS, doc_wxDC_GetTextBackground},
    {sipName_GetTextExtent, SIP_MLMETH_CAST(meth_wxDC_GetTextExtent), METH_VARARGS|METH_KEYWORDS, doc_wxDC_GetTextExtent},
    {sipName_GetTextForeground, meth_wxDC_GetTextForeground, METH_VARARGS, doc_wxDC_GetTextForeground},
    {sipName_GradientFillConcentric, SIP_MLMETH_CAST(meth_wxDC_GradientFillConcentric), METH_VARARGS|METH_KEYWORDS, doc_wxDC_GradientFillConcentric},
    {sipName_GradientFillLinear, SIP_MLMETH_CAST(meth_wxDC_GradientFillLinear), METH_VARARGS|METH_KEYWORDS, doc_wxDC_GradientFillLinear},
    {sipName_MaxX, meth_wxDC_MaxX, METH_VARARGS, doc_wxDC_MaxX},
    {sipName_MaxY, meth_wxDC_MaxY, METH_VARARGS, doc_wxDC_MaxY},
    {sipName_MinX, meth_wxDC_MinX, METH_VARARGS, doc_wxDC_MinX},
    {sipName_MinY, meth_wxDC_MinY, METH_VARARGS, doc_wxDC_MinY},
    {sipName_ResetBoundingBox, meth_wxDC_ResetBoundingBox, METH_VARARGS, doc_wxDC_ResetBoundingBox},
    {sipName_SetBackground, SIP_MLMETH_CAST(meth_wxDC_SetBackground), METH_VARARGS|METH_KEYWORDS, doc_wxDC_SetBackground},
    {sipName_SetBackgroundMode, SIP_MLMETH_CAST(meth_wxDC_SetBackgroundMode), METH_VARARGS|METH_KEYWORDS, doc_wxDC_SetBackgroundMode},
    {sipName_SetBrush, SIP_MLMETH_CAST(meth_wxDC_SetBrush), METH_VARARGS|METH_KEYWORDS, doc_wxDC_SetBrush},
    {sipName_SetClippingRegion, SIP_MLMETH_CAST(meth_wxDC_SetClippingRegion), METH_VARARGS|METH_KEYWORDS, doc_wxDC_SetClippingRegion},
    {sipName_SetDeviceClippingRegion, SIP_MLMETH_CAST(meth_wxDC_SetDeviceClippingRegion), METH_VARARGS|METH_KEYWORDS, doc_wxDC_SetDeviceClippingRegion},
    {sipName_SetGraphicsContext, SIP_MLMETH_CAST(meth_wxDC_SetGraphicsContext), METH_VARARGS|METH_KEYWORDS, doc_wxDC_SetGraphicsContext},
    {sipName_SetLogicalFunction, SIP_MLMETH_CAST(meth_wxDC_SetLogicalFunction), METH_VARARGS|METH_KEYWORDS, doc_wxDC_SetLogicalFunction},
    {sipName_SetPalette, SIP_MLMETH_CAST(meth_wxDC_SetPalette), METH_VARARGS|METH_KEYWORDS, doc_wxDC_SetPalette},
    {sipName_SetPen, SIP_MLMETH_CAST(meth_wxDC_SetPen), METH_VARARGS|METH_KEYWORDS, doc_wxDC_SetPen},
    {sipName_SetTextBackground, SIP_MLMETH_CAST(meth_wxDC_SetTextBackground), METH_VARARGS|METH_KEYWORDS, doc_wxDC_SetTextBackground},
    {sipName_SetTextForeground, SIP_MLMETH_CAST(meth_wxDC_SetTextForeground), METH_VARARGS|METH_KEYWORDS, doc_wxDC_SetTextForeground},
    {sipName_StartDoc, SIP_MLMETH_CAST(meth_wxDC_StartDoc), METH_VARARGS|METH_KEYWORDS, doc_wxDC_StartDoc},
    {sipName_StartPage, meth_wxDC_StartPage, METH_VARARGS, doc_wxDC_StartPage},
    {sipName_StretchBlit, SIP_MLMETH_CAST(meth_wxDC_StretchBlit), METH_VARARGS|METH_KEYWORDS, doc_wxDC_StretchBlit},
    {sipName__DrawEllipseList, SIP_MLMETH_CAST(meth_wxDC__DrawEllipseList), METH_VARARGS|METH_KEYWORDS, doc_wxDC__DrawEllipseList},
    {sipName__DrawLineList, SIP_MLMETH_CAST(meth_wxDC__DrawLineList), METH_VARARGS|METH_KEYWORDS, doc_wxDC__DrawLineList},
    {sipName__DrawLinesFromBuffer, SIP_MLMETH_CAST(meth_wxDC__DrawLinesFromBuffer), METH_VARARGS|METH_KEYWORDS, doc_wxDC__DrawLinesFromBuffer},
    {sipName__DrawPointList, SIP_MLMETH_CAST(meth_wxDC__DrawPointList), METH_VARARGS|METH_KEYWORDS, doc_wxDC__DrawPointList},
    {sipName__DrawPolygonList, SIP_MLMETH_CAST(meth_wxDC__DrawPolygonList), METH_VARARGS|METH_KEYWORDS, doc_wxDC__DrawPolygonList},
    {sipName__DrawRectangleList, SIP_MLMETH_CAST(meth_wxDC__DrawRectangleList), METH_VARARGS|METH_KEYWORDS, doc_wxDC__DrawRectangleList},
    {sipName__DrawTextList, SIP_MLMETH_CAST(meth_wxDC__DrawTextList), METH_VARARGS|METH_KEYWORDS, doc_wxDC__DrawTextList},
    {sipName___nonzero__, meth_wxDC___nonzero__, METH_VARARGS, doc_wxDC___nonzero__}
};

sipVariableDef variables_wxDC[] = {
    {PropertyVariable, sipName_TextForeground, &methods_wxDC[44], &methods_wxDC[62], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_TextExtent, &methods_wxDC[43], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_TextBackground, &methods_wxDC[42], &methods_wxDC[61], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Pixel, &methods_wxDC[41], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Pen, &methods_wxDC[40], &methods_wxDC[60], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_MultiLineTextExtent, &methods_wxDC[39], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_LogicalFunction, &methods_wxDC[38], &methods_wxDC[58], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Handle, &methods_wxDC[37], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_HDC, &methods_wxDC[36], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_GraphicsContext, &methods_wxDC[35], &methods_wxDC[57], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_GdkDrawable, &methods_wxDC[34], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_CGContext, &methods_wxDC[32], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Brush, &methods_wxDC[31], &methods_wxDC[54], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_BackgroundMode, &methods_wxDC[30], &methods_wxDC[53], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Background, &methods_wxDC[29], &methods_wxDC[52], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_AsBitmap, &methods_wxDC[28], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
};

PyDoc_STRVAR(doc_wxDC, "A wxDC is a \"device context\" onto which graphics and text can be\n"
"drawn.");


sipClassTypeDef sipTypeDef__core_wxDC = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SCC|SIP_TYPE_CLASS,
        sipNameNr_wxDC,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        sipNameNr_DC,
        {0, 0, 1},
        74, methods_wxDC,
        0, SIP_NULLPTR,
        16, variables_wxDC,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxDC,
    -1,
    -1,
    supers_wxDC,
    slots_wxDC,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_wxDC,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    release_wxDC,
    cast_wxDC,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    0,
};
