/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.15.0
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_xrc.h"
        #include <wx/xrc/xmlres.h>
        #include <wx/toolbar.h>
        #include <wx/window.h>
        #include <wx/panel.h>
        #include <wx/object.h>
        #include <wx/menu.h>
        #include <wx/menu.h>
        #include <wx/icon.h>
        #include <wx/frame.h>
        #include <wx/dialog.h>
        #include <wx/bitmap.h>
        #include <wx/xml/xml.h>
        #include <wx/xml/xml.h>
        #include <wx/xrc/xmlres.h>
        #include <wx/object.h>
        #include <wx/object.h>
    bool _wxXmlResource_LoadFromBuffer(wxXmlResource* self, wxPyBuffer* data)
    {
        static int s_memFileIdx = 0;
        
        // Check for memory FS. If not present, load the handler:
        wxMemoryFSHandler::AddFile(wxT("XRC_resource/dummy_file"),
                                   wxT("dummy data"));
        wxFileSystem fsys;
        wxFSFile *f = fsys.OpenFile(wxT("memory:XRC_resource/dummy_file"));
        wxMemoryFSHandler::RemoveFile(wxT("XRC_resource/dummy_file"));
        if (f)
            delete f;
        else
            wxFileSystem::AddHandler(new wxMemoryFSHandler);
        
        // Now put the resource data into the memory FS
        wxString filename(wxT("XRC_resource/data_string_"));
        filename << s_memFileIdx;
        s_memFileIdx += 1;
        wxMemoryFSHandler::AddFile(filename, data->m_ptr, data->m_len);
        
        // Load the "file" into the resource object
        bool retval = self->Load(wxT("memory:") + filename );
        return retval;
    }


class sipwxXmlResource : public ::wxXmlResource
{
public:
    sipwxXmlResource(const ::wxString&, int, const ::wxString&);
    sipwxXmlResource(int, const ::wxString&);
    ~sipwxXmlResource();

public:
    sipSimpleWrapper *sipPySelf;

private:
    sipwxXmlResource(const sipwxXmlResource &);
    sipwxXmlResource &operator = (const sipwxXmlResource &);
};

sipwxXmlResource::sipwxXmlResource(const ::wxString& filemask, int flags, const ::wxString& domain): ::wxXmlResource(filemask, flags, domain), sipPySelf(SIP_NULLPTR)
{
}

sipwxXmlResource::sipwxXmlResource(int flags, const ::wxString& domain): ::wxXmlResource(flags, domain), sipPySelf(SIP_NULLPTR)
{
}

sipwxXmlResource::~sipwxXmlResource()
{
    sipInstanceDestroyedEx(&sipPySelf);
}


PyDoc_STRVAR(doc_wxXmlResource_AddHandler, "AddHandler(handler) -> None\n"
"\n"
"Initializes only a specific handler (or custom handler).");

extern "C" {static PyObject *meth_wxXmlResource_AddHandler(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxXmlResource_AddHandler(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxXmlResourceHandler* handler;
        ::wxXmlResource *sipCpp;

        static const char *sipKwdList[] = {
            sipName_handler,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ:", &sipSelf, sipType_wxXmlResource, &sipCpp, sipType_wxXmlResourceHandler, &handler))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->AddHandler(handler);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_XmlResource, sipName_AddHandler, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxXmlResource_InsertHandler, "InsertHandler(handler) -> None\n"
"\n"
"Add a new handler at the beginning of the handler list.");

extern "C" {static PyObject *meth_wxXmlResource_InsertHandler(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxXmlResource_InsertHandler(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxXmlResourceHandler* handler;
        ::wxXmlResource *sipCpp;

        static const char *sipKwdList[] = {
            sipName_handler,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ:", &sipSelf, sipType_wxXmlResource, &sipCpp, sipType_wxXmlResourceHandler, &handler))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->InsertHandler(handler);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_XmlResource, sipName_InsertHandler, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxXmlResource_AttachUnknownControl, "AttachUnknownControl(name, control, parent=nullptr) -> bool\n"
"\n"
"Attaches an unknown control to the given panel/window/dialog.");

extern "C" {static PyObject *meth_wxXmlResource_AttachUnknownControl(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxXmlResource_AttachUnknownControl(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxString* name;
        int nameState = 0;
        ::wxWindow* control;
        ::wxWindow* parent = nullptr;
        ::wxXmlResource *sipCpp;

        static const char *sipKwdList[] = {
            sipName_name,
            sipName_control,
            sipName_parent,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1J8|J8", &sipSelf, sipType_wxXmlResource, &sipCpp, sipType_wxString, &name, &nameState, sipType_wxWindow, &control, sipType_wxWindow, &parent))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->AttachUnknownControl(*name, control, parent);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name), sipType_wxString, nameState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_XmlResource, sipName_AttachUnknownControl, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxXmlResource_ClearHandlers, "ClearHandlers() -> None\n"
"\n"
"Removes all handlers and deletes them (this means that any handlers\n"
"added using AddHandler() must be allocated on the heap).");

extern "C" {static PyObject *meth_wxXmlResource_ClearHandlers(PyObject *, PyObject *);}
static PyObject *meth_wxXmlResource_ClearHandlers(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxXmlResource *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxXmlResource, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->ClearHandlers();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_XmlResource, sipName_ClearHandlers, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxXmlResource_CompareVersion, "CompareVersion(major, minor, release, revision) -> int\n"
"\n"
"Compares the XRC version to the argument.");

extern "C" {static PyObject *meth_wxXmlResource_CompareVersion(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxXmlResource_CompareVersion(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int major;
        int minor;
        int release;
        int revision;
        const ::wxXmlResource *sipCpp;

        static const char *sipKwdList[] = {
            sipName_major,
            sipName_minor,
            sipName_release,
            sipName_revision,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Biiii", &sipSelf, sipType_wxXmlResource, &sipCpp, &major, &minor, &release, &revision))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->CompareVersion(major, minor, release, revision);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_XmlResource, sipName_CompareVersion, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxXmlResource_EnableFeature, "EnableFeature(feature) -> None\n"
"\n"
"Add a feature considered to be enabled.");

extern "C" {static PyObject *meth_wxXmlResource_EnableFeature(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxXmlResource_EnableFeature(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxString* feature;
        int featureState = 0;
        ::wxXmlResource *sipCpp;

        static const char *sipKwdList[] = {
            sipName_feature,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxXmlResource, &sipCpp, sipType_wxString, &feature, &featureState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->EnableFeature(*feature);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(feature), sipType_wxString, featureState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_XmlResource, sipName_EnableFeature, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxXmlResource_GetDomain, "GetDomain() -> str\n"
"\n"
"Returns the domain (message catalog) that will be used to load\n"
"translatable strings in the XRC.");

extern "C" {static PyObject *meth_wxXmlResource_GetDomain(PyObject *, PyObject *);}
static PyObject *meth_wxXmlResource_GetDomain(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxXmlResource *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxXmlResource, &sipCpp))
        {
            ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxString(sipCpp->GetDomain());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_XmlResource, sipName_GetDomain, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxXmlResource_GetFlags, "GetFlags() -> int\n"
"\n"
"Returns flags, which may be a bitlist of wxXmlResourceFlags\n"
"enumeration values.");

extern "C" {static PyObject *meth_wxXmlResource_GetFlags(PyObject *, PyObject *);}
static PyObject *meth_wxXmlResource_GetFlags(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxXmlResource *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxXmlResource, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetFlags();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_XmlResource, sipName_GetFlags, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxXmlResource_GetResourceNode, "GetResourceNode(name) -> XmlNode\n"
"\n"
"Returns the wxXmlNode containing the definition of the object with the\n"
"given name or nullptr.");

extern "C" {static PyObject *meth_wxXmlResource_GetResourceNode(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxXmlResource_GetResourceNode(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxString* name;
        int nameState = 0;
        const ::wxXmlResource *sipCpp;

        static const char *sipKwdList[] = {
            sipName_name,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxXmlResource, &sipCpp, sipType_wxString, &name, &nameState))
        {
            const ::wxXmlNode*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetResourceNode(*name);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name), sipType_wxString, nameState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(const_cast< ::wxXmlNode *>(sipRes), sipType_wxXmlNode, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_XmlResource, sipName_GetResourceNode, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxXmlResource_GetVersion, "GetVersion() -> int\n"
"\n"
"Returns version information (a.b.c.d = d + 256*c + 2562*b + 2563*a).");

extern "C" {static PyObject *meth_wxXmlResource_GetVersion(PyObject *, PyObject *);}
static PyObject *meth_wxXmlResource_GetVersion(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxXmlResource *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxXmlResource, &sipCpp))
        {
            long sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetVersion();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_XmlResource, sipName_GetVersion, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxXmlResource_InitAllHandlers, "InitAllHandlers() -> None\n"
"\n"
"Initializes handlers for all supported controls/windows.");

extern "C" {static PyObject *meth_wxXmlResource_InitAllHandlers(PyObject *, PyObject *);}
static PyObject *meth_wxXmlResource_InitAllHandlers(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxXmlResource *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxXmlResource, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->InitAllHandlers();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_XmlResource, sipName_InitAllHandlers, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxXmlResource_Load, "Load(filemask) -> bool\n"
"\n"
"Loads resources from XML files that match given filemask.");

extern "C" {static PyObject *meth_wxXmlResource_Load(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxXmlResource_Load(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxString* filemask;
        int filemaskState = 0;
        ::wxXmlResource *sipCpp;

        static const char *sipKwdList[] = {
            sipName_filemask,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxXmlResource, &sipCpp, sipType_wxString, &filemask, &filemaskState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Load(*filemask);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(filemask), sipType_wxString, filemaskState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_XmlResource, sipName_Load, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxXmlResource_LoadDocument, "LoadDocument(doc, name=\"\") -> bool\n"
"\n"
"Load resources from the XML document containing them.");

extern "C" {static PyObject *meth_wxXmlResource_LoadDocument(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxXmlResource_LoadDocument(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxXmlDocument* doc;
        const ::wxString& namedef = wxString();
        const ::wxString* name = &namedef;
        int nameState = 0;
        ::wxXmlResource *sipCpp;

        static const char *sipKwdList[] = {
            sipName_doc,
            sipName_name,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ8|J1", &sipSelf, sipType_wxXmlResource, &sipCpp, sipType_wxXmlDocument, &doc, sipType_wxString, &name, &nameState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->LoadDocument(doc, *name);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name), sipType_wxString, nameState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_XmlResource, sipName_LoadDocument, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxXmlResource_LoadFile, "LoadFile(file) -> bool\n"
"\n"
"Simpler form of Load() for loading a single XRC file.");

extern "C" {static PyObject *meth_wxXmlResource_LoadFile(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxXmlResource_LoadFile(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxFileName* file;
        int fileState = 0;
        ::wxXmlResource *sipCpp;

        static const char *sipKwdList[] = {
            sipName_file,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxXmlResource, &sipCpp, sipType_wxFileName, &file, &fileState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->LoadFile(*file);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxFileName *>(file), sipType_wxFileName, fileState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_XmlResource, sipName_LoadFile, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxXmlResource_LoadAllFiles, "LoadAllFiles(dirname) -> bool\n"
"\n"
"Loads all .xrc files from directory dirname.");

extern "C" {static PyObject *meth_wxXmlResource_LoadAllFiles(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxXmlResource_LoadAllFiles(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxString* dirname;
        int dirnameState = 0;
        ::wxXmlResource *sipCpp;

        static const char *sipKwdList[] = {
            sipName_dirname,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxXmlResource, &sipCpp, sipType_wxString, &dirname, &dirnameState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->LoadAllFiles(*dirname);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(dirname), sipType_wxString, dirnameState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_XmlResource, sipName_LoadAllFiles, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxXmlResource_LoadBitmap, "LoadBitmap(name) -> Bitmap\n"
"\n"
"Loads a bitmap resource from a file.");

extern "C" {static PyObject *meth_wxXmlResource_LoadBitmap(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxXmlResource_LoadBitmap(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxString* name;
        int nameState = 0;
        ::wxXmlResource *sipCpp;

        static const char *sipKwdList[] = {
            sipName_name,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxXmlResource, &sipCpp, sipType_wxString, &name, &nameState))
        {
            ::wxBitmap*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxBitmap(sipCpp->LoadBitmap(*name));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name), sipType_wxString, nameState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxBitmap, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_XmlResource, sipName_LoadBitmap, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxXmlResource_LoadDialog, "LoadDialog(parent, name) -> Dialog\n"
"LoadDialog(dlg, parent, name) -> bool\n"
"\n"
"Loads a dialog.\n"
"");

extern "C" {static PyObject *meth_wxXmlResource_LoadDialog(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxXmlResource_LoadDialog(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxWindow* parent;
        const ::wxString* name;
        int nameState = 0;
        ::wxXmlResource *sipCpp;

        static const char *sipKwdList[] = {
            sipName_parent,
            sipName_name,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ8J1", &sipSelf, sipType_wxXmlResource, &sipCpp, sipType_wxWindow, &parent, sipType_wxString, &name, &nameState))
        {
            ::wxDialog*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->LoadDialog(parent, *name);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name), sipType_wxString, nameState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes, sipType_wxDialog, SIP_NULLPTR);
        }
    }

    {
        ::wxDialog* dlg;
        ::wxWindow* parent;
        const ::wxString* name;
        int nameState = 0;
        ::wxXmlResource *sipCpp;

        static const char *sipKwdList[] = {
            sipName_dlg,
            sipName_parent,
            sipName_name,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ8J8J1", &sipSelf, sipType_wxXmlResource, &sipCpp, sipType_wxDialog, &dlg, sipType_wxWindow, &parent, sipType_wxString, &name, &nameState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->LoadDialog(dlg, parent, *name);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name), sipType_wxString, nameState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_XmlResource, sipName_LoadDialog, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxXmlResource_LoadFrame, "LoadFrame(parent, name) -> Frame\n"
"LoadFrame(frame, parent, name) -> bool\n"
"\n"
"Loads a frame from the resource.\n"
"");

extern "C" {static PyObject *meth_wxXmlResource_LoadFrame(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxXmlResource_LoadFrame(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxWindow* parent;
        const ::wxString* name;
        int nameState = 0;
        ::wxXmlResource *sipCpp;

        static const char *sipKwdList[] = {
            sipName_parent,
            sipName_name,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ8J1", &sipSelf, sipType_wxXmlResource, &sipCpp, sipType_wxWindow, &parent, sipType_wxString, &name, &nameState))
        {
            ::wxFrame*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->LoadFrame(parent, *name);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name), sipType_wxString, nameState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes, sipType_wxFrame, SIP_NULLPTR);
        }
    }

    {
        ::wxFrame* frame;
        ::wxWindow* parent;
        const ::wxString* name;
        int nameState = 0;
        ::wxXmlResource *sipCpp;

        static const char *sipKwdList[] = {
            sipName_frame,
            sipName_parent,
            sipName_name,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ8J8J1", &sipSelf, sipType_wxXmlResource, &sipCpp, sipType_wxFrame, &frame, sipType_wxWindow, &parent, sipType_wxString, &name, &nameState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->LoadFrame(frame, parent, *name);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name), sipType_wxString, nameState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_XmlResource, sipName_LoadFrame, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxXmlResource_LoadIcon, "LoadIcon(name) -> Icon\n"
"\n"
"Loads an icon resource from a file.");

extern "C" {static PyObject *meth_wxXmlResource_LoadIcon(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxXmlResource_LoadIcon(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxString* name;
        int nameState = 0;
        ::wxXmlResource *sipCpp;

        static const char *sipKwdList[] = {
            sipName_name,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxXmlResource, &sipCpp, sipType_wxString, &name, &nameState))
        {
            ::wxIcon*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxIcon(sipCpp->LoadIcon(*name));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name), sipType_wxString, nameState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxIcon, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_XmlResource, sipName_LoadIcon, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxXmlResource_LoadMenu, "LoadMenu(name) -> Menu\n"
"\n"
"Loads menu from resource.");

extern "C" {static PyObject *meth_wxXmlResource_LoadMenu(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxXmlResource_LoadMenu(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxString* name;
        int nameState = 0;
        ::wxXmlResource *sipCpp;

        static const char *sipKwdList[] = {
            sipName_name,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxXmlResource, &sipCpp, sipType_wxString, &name, &nameState))
        {
            ::wxMenu*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->LoadMenu(*name);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name), sipType_wxString, nameState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes, sipType_wxMenu, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_XmlResource, sipName_LoadMenu, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxXmlResource_LoadMenuBar, "LoadMenuBar(parent, name) -> MenuBar\n"
"LoadMenuBar(name) -> MenuBar\n"
"\n"
"Loads a menubar from resource.\n"
"");

extern "C" {static PyObject *meth_wxXmlResource_LoadMenuBar(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxXmlResource_LoadMenuBar(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxWindow* parent;
        const ::wxString* name;
        int nameState = 0;
        ::wxXmlResource *sipCpp;

        static const char *sipKwdList[] = {
            sipName_parent,
            sipName_name,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ8J1", &sipSelf, sipType_wxXmlResource, &sipCpp, sipType_wxWindow, &parent, sipType_wxString, &name, &nameState))
        {
            ::wxMenuBar*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->LoadMenuBar(parent, *name);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name), sipType_wxString, nameState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes, sipType_wxMenuBar, SIP_NULLPTR);
        }
    }

    {
        const ::wxString* name;
        int nameState = 0;
        ::wxXmlResource *sipCpp;

        static const char *sipKwdList[] = {
            sipName_name,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxXmlResource, &sipCpp, sipType_wxString, &name, &nameState))
        {
            ::wxMenuBar*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->LoadMenuBar(*name);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name), sipType_wxString, nameState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes, sipType_wxMenuBar, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_XmlResource, sipName_LoadMenuBar, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxXmlResource_LoadObject, "LoadObject(parent, name, classname) -> Object\n"
"LoadObject(instance, parent, name, classname) -> bool\n"
"\n"
"Load an object from the resource specifying both the resource name and\n"
"the class name.\n"
"");

extern "C" {static PyObject *meth_wxXmlResource_LoadObject(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxXmlResource_LoadObject(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxWindow* parent;
        const ::wxString* name;
        int nameState = 0;
        const ::wxString* classname;
        int classnameState = 0;
        ::wxXmlResource *sipCpp;

        static const char *sipKwdList[] = {
            sipName_parent,
            sipName_name,
            sipName_classname,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ8J1J1", &sipSelf, sipType_wxXmlResource, &sipCpp, sipType_wxWindow, &parent, sipType_wxString, &name, &nameState, sipType_wxString, &classname, &classnameState))
        {
            ::wxObject*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->LoadObject(parent, *name, *classname);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name), sipType_wxString, nameState);
            sipReleaseType(const_cast< ::wxString *>(classname), sipType_wxString, classnameState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes, sipType_wxObject, SIP_NULLPTR);
        }
    }

    {
        ::wxObject* instance;
        ::wxWindow* parent;
        const ::wxString* name;
        int nameState = 0;
        const ::wxString* classname;
        int classnameState = 0;
        ::wxXmlResource *sipCpp;

        static const char *sipKwdList[] = {
            sipName_instance,
            sipName_parent,
            sipName_name,
            sipName_classname,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ8J8J1J1", &sipSelf, sipType_wxXmlResource, &sipCpp, sipType_wxObject, &instance, sipType_wxWindow, &parent, sipType_wxString, &name, &nameState, sipType_wxString, &classname, &classnameState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->LoadObject(instance, parent, *name, *classname);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name), sipType_wxString, nameState);
            sipReleaseType(const_cast< ::wxString *>(classname), sipType_wxString, classnameState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_XmlResource, sipName_LoadObject, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxXmlResource_LoadObjectRecursively, "LoadObjectRecursively(parent, name, classname) -> Object\n"
"LoadObjectRecursively(instance, parent, name, classname) -> bool\n"
"\n"
"Load an object from anywhere in the resource tree.\n"
"");

extern "C" {static PyObject *meth_wxXmlResource_LoadObjectRecursively(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxXmlResource_LoadObjectRecursively(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxWindow* parent;
        const ::wxString* name;
        int nameState = 0;
        const ::wxString* classname;
        int classnameState = 0;
        ::wxXmlResource *sipCpp;

        static const char *sipKwdList[] = {
            sipName_parent,
            sipName_name,
            sipName_classname,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ8J1J1", &sipSelf, sipType_wxXmlResource, &sipCpp, sipType_wxWindow, &parent, sipType_wxString, &name, &nameState, sipType_wxString, &classname, &classnameState))
        {
            ::wxObject*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->LoadObjectRecursively(parent, *name, *classname);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name), sipType_wxString, nameState);
            sipReleaseType(const_cast< ::wxString *>(classname), sipType_wxString, classnameState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes, sipType_wxObject, SIP_NULLPTR);
        }
    }

    {
        ::wxObject* instance;
        ::wxWindow* parent;
        const ::wxString* name;
        int nameState = 0;
        const ::wxString* classname;
        int classnameState = 0;
        ::wxXmlResource *sipCpp;

        static const char *sipKwdList[] = {
            sipName_instance,
            sipName_parent,
            sipName_name,
            sipName_classname,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ8J8J1J1", &sipSelf, sipType_wxXmlResource, &sipCpp, sipType_wxObject, &instance, sipType_wxWindow, &parent, sipType_wxString, &name, &nameState, sipType_wxString, &classname, &classnameState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->LoadObjectRecursively(instance, parent, *name, *classname);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name), sipType_wxString, nameState);
            sipReleaseType(const_cast< ::wxString *>(classname), sipType_wxString, classnameState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_XmlResource, sipName_LoadObjectRecursively, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxXmlResource_LoadPanel, "LoadPanel(parent, name) -> Panel\n"
"LoadPanel(panel, parent, name) -> bool\n"
"\n"
"Loads a panel.\n"
"");

extern "C" {static PyObject *meth_wxXmlResource_LoadPanel(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxXmlResource_LoadPanel(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxWindow* parent;
        const ::wxString* name;
        int nameState = 0;
        ::wxXmlResource *sipCpp;

        static const char *sipKwdList[] = {
            sipName_parent,
            sipName_name,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ8J1", &sipSelf, sipType_wxXmlResource, &sipCpp, sipType_wxWindow, &parent, sipType_wxString, &name, &nameState))
        {
            ::wxPanel*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->LoadPanel(parent, *name);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name), sipType_wxString, nameState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes, sipType_wxPanel, SIP_NULLPTR);
        }
    }

    {
        ::wxPanel* panel;
        ::wxWindow* parent;
        const ::wxString* name;
        int nameState = 0;
        ::wxXmlResource *sipCpp;

        static const char *sipKwdList[] = {
            sipName_panel,
            sipName_parent,
            sipName_name,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ8J8J1", &sipSelf, sipType_wxXmlResource, &sipCpp, sipType_wxPanel, &panel, sipType_wxWindow, &parent, sipType_wxString, &name, &nameState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->LoadPanel(panel, parent, *name);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name), sipType_wxString, nameState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_XmlResource, sipName_LoadPanel, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxXmlResource_LoadToolBar, "LoadToolBar(parent, name) -> ToolBar\n"
"\n"
"Loads a toolbar.");

extern "C" {static PyObject *meth_wxXmlResource_LoadToolBar(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxXmlResource_LoadToolBar(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxWindow* parent;
        const ::wxString* name;
        int nameState = 0;
        ::wxXmlResource *sipCpp;

        static const char *sipKwdList[] = {
            sipName_parent,
            sipName_name,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ8J1", &sipSelf, sipType_wxXmlResource, &sipCpp, sipType_wxWindow, &parent, sipType_wxString, &name, &nameState))
        {
            ::wxToolBar*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->LoadToolBar(parent, *name);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name), sipType_wxString, nameState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes, sipType_wxToolBar, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_XmlResource, sipName_LoadToolBar, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxXmlResource_SetDomain, "SetDomain(domain) -> None\n"
"\n"
"Sets the domain (message catalog) that will be used to load\n"
"translatable strings in the XRC.");

extern "C" {static PyObject *meth_wxXmlResource_SetDomain(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxXmlResource_SetDomain(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxString* domain;
        int domainState = 0;
        ::wxXmlResource *sipCpp;

        static const char *sipKwdList[] = {
            sipName_domain,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxXmlResource, &sipCpp, sipType_wxString, &domain, &domainState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetDomain(*domain);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(domain), sipType_wxString, domainState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_XmlResource, sipName_SetDomain, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxXmlResource_SetFlags, "SetFlags(flags) -> None\n"
"\n"
"Sets flags (bitlist of wxXmlResourceFlags enumeration values).");

extern "C" {static PyObject *meth_wxXmlResource_SetFlags(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxXmlResource_SetFlags(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int flags;
        ::wxXmlResource *sipCpp;

        static const char *sipKwdList[] = {
            sipName_flags,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxXmlResource, &sipCpp, &flags))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetFlags(flags);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_XmlResource, sipName_SetFlags, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxXmlResource_Unload, "Unload(filename) -> bool\n"
"\n"
"This function unloads a resource previously loaded by Load().");

extern "C" {static PyObject *meth_wxXmlResource_Unload(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxXmlResource_Unload(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxString* filename;
        int filenameState = 0;
        ::wxXmlResource *sipCpp;

        static const char *sipKwdList[] = {
            sipName_filename,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxXmlResource, &sipCpp, sipType_wxString, &filename, &filenameState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Unload(*filename);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(filename), sipType_wxString, filenameState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_XmlResource, sipName_Unload, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxXmlResource_AddSubclassFactory, "AddSubclassFactory(factory) -> None\n"
"\n"
"Registers subclasses factory for use in XRC.");

extern "C" {static PyObject *meth_wxXmlResource_AddSubclassFactory(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxXmlResource_AddSubclassFactory(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxXmlSubclassFactory* factory;

        static const char *sipKwdList[] = {
            sipName_factory,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "J:", sipType_wxXmlSubclassFactory, &factory))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            ::wxXmlResource::AddSubclassFactory(factory);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_XmlResource, sipName_AddSubclassFactory, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxXmlResource_FindXRCIDById, "FindXRCIDById(numId) -> str\n"
"\n"
"Returns a string ID corresponding to the given numeric ID.");

extern "C" {static PyObject *meth_wxXmlResource_FindXRCIDById(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxXmlResource_FindXRCIDById(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int numId;

        static const char *sipKwdList[] = {
            sipName_numId,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "i", &numId))
        {
            ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxString(::wxXmlResource::FindXRCIDById(numId));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_XmlResource, sipName_FindXRCIDById, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxXmlResource_Get, "Get() -> XmlResource\n"
"\n"
"Gets the global resources object or creates one if none exists.");

extern "C" {static PyObject *meth_wxXmlResource_Get(PyObject *, PyObject *);}
static PyObject *meth_wxXmlResource_Get(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
            ::wxXmlResource*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = ::wxXmlResource::Get();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes, sipType_wxXmlResource, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_XmlResource, sipName_Get, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxXmlResource_GetXRCID, "GetXRCID(str_id, value_if_not_found=ID_NONE) -> int\n"
"\n"
"Returns a numeric ID that is equivalent to the string ID used in an\n"
"XML resource.");

extern "C" {static PyObject *meth_wxXmlResource_GetXRCID(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxXmlResource_GetXRCID(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxString* str_id;
        int str_idState = 0;
        int value_if_not_found = wxID_NONE;

        static const char *sipKwdList[] = {
            sipName_str_id,
            sipName_value_if_not_found,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "J1|i", sipType_wxString, &str_id, &str_idState, &value_if_not_found))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = ::wxXmlResource::GetXRCID(*str_id, value_if_not_found);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(str_id), sipType_wxString, str_idState);

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_XmlResource, sipName_GetXRCID, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxXmlResource_Set, "Set(res) -> XmlResource\n"
"\n"
"Sets the global resources object and returns a pointer to the previous one (may be nullptr).");

extern "C" {static PyObject *meth_wxXmlResource_Set(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxXmlResource_Set(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxXmlResource* res;

        static const char *sipKwdList[] = {
            sipName_res,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "J:", sipType_wxXmlResource, &res))
        {
            ::wxXmlResource*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = ::wxXmlResource::Set(res);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes, sipType_wxXmlResource, Py_None);
        }
    }

    sipNoMethod(sipParseErr, sipName_XmlResource, sipName_Set, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxXmlResource_LoadFromBuffer, "LoadFromBuffer(data) -> bool\n"
"\n"
"Load the resource from a bytes string or other data buffer compatible\n"
"object.");

extern "C" {static PyObject *meth_wxXmlResource_LoadFromBuffer(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxXmlResource_LoadFromBuffer(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxPyBuffer* data;
        int dataState = 0;
        ::wxXmlResource *sipCpp;

        static const char *sipKwdList[] = {
            sipName_data,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ0", &sipSelf, sipType_wxXmlResource, &sipCpp, sipType_wxPyBuffer, &data, &dataState))
        {
            bool sipRes = 0;
            int sipIsErr = 0;
        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxXmlResource_LoadFromBuffer(sipCpp, data);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;
            sipReleaseType(data, sipType_wxPyBuffer, dataState);

            if (sipIsErr)
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_XmlResource, sipName_LoadFromBuffer, SIP_NULLPTR);

    return SIP_NULLPTR;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_wxXmlResource(void *, const sipTypeDef *);}
static void *cast_wxXmlResource(void *sipCppV, const sipTypeDef *targetType)
{
    ::wxXmlResource *sipCpp = reinterpret_cast< ::wxXmlResource *>(sipCppV);

    if (targetType == sipType_wxXmlResource)
        return sipCppV;

    if (targetType == sipType_wxObject)
        return static_cast< ::wxObject *>(sipCpp);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxXmlResource(void *, int);}
static void release_wxXmlResource(void *sipCppV, int sipState)
{
    Py_BEGIN_ALLOW_THREADS

    if (sipState & SIP_DERIVED_CLASS)
        delete reinterpret_cast<sipwxXmlResource *>(sipCppV);
    else
        delete reinterpret_cast< ::wxXmlResource *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void *array_wxXmlResource(Py_ssize_t);}
static void *array_wxXmlResource(Py_ssize_t sipNrElem)
{
    return new ::wxXmlResource[sipNrElem];
}


extern "C" {static void array_delete_wxXmlResource(void *);}
static void array_delete_wxXmlResource(void *sipCpp)
{
    delete[] reinterpret_cast< ::wxXmlResource *>(sipCpp);
}


extern "C" {static void dealloc_wxXmlResource(sipSimpleWrapper *);}
static void dealloc_wxXmlResource(sipSimpleWrapper *sipSelf)
{
    if (sipIsDerivedClass(sipSelf))
        reinterpret_cast<sipwxXmlResource *>(sipGetAddress(sipSelf))->sipPySelf = SIP_NULLPTR;

    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxXmlResource(sipGetAddress(sipSelf), sipIsDerivedClass(sipSelf));
    }
}


extern "C" {static void *init_type_wxXmlResource(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxXmlResource(sipSimpleWrapper *sipSelf, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    sipwxXmlResource *sipCpp = SIP_NULLPTR;

    {
        const ::wxString* filemask;
        int filemaskState = 0;
        int flags = wxXRC_USE_LOCALE;
        const ::wxString& domaindef = wxEmptyString;
        const ::wxString* domain = &domaindef;
        int domainState = 0;

        static const char *sipKwdList[] = {
            sipName_filemask,
            sipName_flags,
            sipName_domain,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J1|iJ1", sipType_wxString, &filemask, &filemaskState, &flags, sipType_wxString, &domain, &domainState))
        {
        Py_BEGIN_ALLOW_THREADS
        sipCpp = new sipwxXmlResource(*filemask,flags,*domain);
        sipCpp->InitAllHandlers();
        Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(filemask), sipType_wxString, filemaskState);
            sipReleaseType(const_cast< ::wxString *>(domain), sipType_wxString, domainState);

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    {
        int flags = wxXRC_USE_LOCALE;
        const ::wxString& domaindef = wxEmptyString;
        const ::wxString* domain = &domaindef;
        int domainState = 0;

        static const char *sipKwdList[] = {
            sipName_flags,
            sipName_domain,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "|iJ1", &flags, sipType_wxString, &domain, &domainState))
        {
        Py_BEGIN_ALLOW_THREADS
        sipCpp = new sipwxXmlResource(flags,*domain);
        sipCpp->InitAllHandlers();
        Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(domain), sipType_wxString, domainState);

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_wxXmlResource[] = {{14, 0, 1}};


static PyMethodDef methods_wxXmlResource[] = {
    {sipName_AddHandler, SIP_MLMETH_CAST(meth_wxXmlResource_AddHandler), METH_VARARGS|METH_KEYWORDS, doc_wxXmlResource_AddHandler},
    {sipName_AddSubclassFactory, SIP_MLMETH_CAST(meth_wxXmlResource_AddSubclassFactory), METH_VARARGS|METH_KEYWORDS, doc_wxXmlResource_AddSubclassFactory},
    {sipName_AttachUnknownControl, SIP_MLMETH_CAST(meth_wxXmlResource_AttachUnknownControl), METH_VARARGS|METH_KEYWORDS, doc_wxXmlResource_AttachUnknownControl},
    {sipName_ClearHandlers, meth_wxXmlResource_ClearHandlers, METH_VARARGS, doc_wxXmlResource_ClearHandlers},
    {sipName_CompareVersion, SIP_MLMETH_CAST(meth_wxXmlResource_CompareVersion), METH_VARARGS|METH_KEYWORDS, doc_wxXmlResource_CompareVersion},
    {sipName_EnableFeature, SIP_MLMETH_CAST(meth_wxXmlResource_EnableFeature), METH_VARARGS|METH_KEYWORDS, doc_wxXmlResource_EnableFeature},
    {sipName_FindXRCIDById, SIP_MLMETH_CAST(meth_wxXmlResource_FindXRCIDById), METH_VARARGS|METH_KEYWORDS, doc_wxXmlResource_FindXRCIDById},
    {sipName_Get, meth_wxXmlResource_Get, METH_VARARGS, doc_wxXmlResource_Get},
    {sipName_GetDomain, meth_wxXmlResource_GetDomain, METH_VARARGS, doc_wxXmlResource_GetDomain},
    {sipName_GetFlags, meth_wxXmlResource_GetFlags, METH_VARARGS, doc_wxXmlResource_GetFlags},
    {sipName_GetResourceNode, SIP_MLMETH_CAST(meth_wxXmlResource_GetResourceNode), METH_VARARGS|METH_KEYWORDS, doc_wxXmlResource_GetResourceNode},
    {sipName_GetVersion, meth_wxXmlResource_GetVersion, METH_VARARGS, doc_wxXmlResource_GetVersion},
    {sipName_GetXRCID, SIP_MLMETH_CAST(meth_wxXmlResource_GetXRCID), METH_VARARGS|METH_KEYWORDS, doc_wxXmlResource_GetXRCID},
    {sipName_InitAllHandlers, meth_wxXmlResource_InitAllHandlers, METH_VARARGS, doc_wxXmlResource_InitAllHandlers},
    {sipName_InsertHandler, SIP_MLMETH_CAST(meth_wxXmlResource_InsertHandler), METH_VARARGS|METH_KEYWORDS, doc_wxXmlResource_InsertHandler},
    {sipName_Load, SIP_MLMETH_CAST(meth_wxXmlResource_Load), METH_VARARGS|METH_KEYWORDS, doc_wxXmlResource_Load},
    {sipName_LoadAllFiles, SIP_MLMETH_CAST(meth_wxXmlResource_LoadAllFiles), METH_VARARGS|METH_KEYWORDS, doc_wxXmlResource_LoadAllFiles},
    {sipName_LoadBitmap, SIP_MLMETH_CAST(meth_wxXmlResource_LoadBitmap), METH_VARARGS|METH_KEYWORDS, doc_wxXmlResource_LoadBitmap},
    {sipName_LoadDialog, SIP_MLMETH_CAST(meth_wxXmlResource_LoadDialog), METH_VARARGS|METH_KEYWORDS, doc_wxXmlResource_LoadDialog},
    {sipName_LoadDocument, SIP_MLMETH_CAST(meth_wxXmlResource_LoadDocument), METH_VARARGS|METH_KEYWORDS, doc_wxXmlResource_LoadDocument},
    {sipName_LoadFile, SIP_MLMETH_CAST(meth_wxXmlResource_LoadFile), METH_VARARGS|METH_KEYWORDS, doc_wxXmlResource_LoadFile},
    {sipName_LoadFrame, SIP_MLMETH_CAST(meth_wxXmlResource_LoadFrame), METH_VARARGS|METH_KEYWORDS, doc_wxXmlResource_LoadFrame},
    {sipName_LoadFromBuffer, SIP_MLMETH_CAST(meth_wxXmlResource_LoadFromBuffer), METH_VARARGS|METH_KEYWORDS, doc_wxXmlResource_LoadFromBuffer},
    {sipName_LoadIcon, SIP_MLMETH_CAST(meth_wxXmlResource_LoadIcon), METH_VARARGS|METH_KEYWORDS, doc_wxXmlResource_LoadIcon},
    {sipName_LoadMenu, SIP_MLMETH_CAST(meth_wxXmlResource_LoadMenu), METH_VARARGS|METH_KEYWORDS, doc_wxXmlResource_LoadMenu},
    {sipName_LoadMenuBar, SIP_MLMETH_CAST(meth_wxXmlResource_LoadMenuBar), METH_VARARGS|METH_KEYWORDS, doc_wxXmlResource_LoadMenuBar},
    {sipName_LoadObject, SIP_MLMETH_CAST(meth_wxXmlResource_LoadObject), METH_VARARGS|METH_KEYWORDS, doc_wxXmlResource_LoadObject},
    {sipName_LoadObjectRecursively, SIP_MLMETH_CAST(meth_wxXmlResource_LoadObjectRecursively), METH_VARARGS|METH_KEYWORDS, doc_wxXmlResource_LoadObjectRecursively},
    {sipName_LoadPanel, SIP_MLMETH_CAST(meth_wxXmlResource_LoadPanel), METH_VARARGS|METH_KEYWORDS, doc_wxXmlResource_LoadPanel},
    {sipName_LoadToolBar, SIP_MLMETH_CAST(meth_wxXmlResource_LoadToolBar), METH_VARARGS|METH_KEYWORDS, doc_wxXmlResource_LoadToolBar},
    {sipName_Set, SIP_MLMETH_CAST(meth_wxXmlResource_Set), METH_VARARGS|METH_KEYWORDS, doc_wxXmlResource_Set},
    {sipName_SetDomain, SIP_MLMETH_CAST(meth_wxXmlResource_SetDomain), METH_VARARGS|METH_KEYWORDS, doc_wxXmlResource_SetDomain},
    {sipName_SetFlags, SIP_MLMETH_CAST(meth_wxXmlResource_SetFlags), METH_VARARGS|METH_KEYWORDS, doc_wxXmlResource_SetFlags},
    {sipName_Unload, SIP_MLMETH_CAST(meth_wxXmlResource_Unload), METH_VARARGS|METH_KEYWORDS, doc_wxXmlResource_Unload}
};

sipVariableDef variables_wxXmlResource[] = {
    {PropertyVariable, sipName_Version, &methods_wxXmlResource[11], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Flags, &methods_wxXmlResource[9], &methods_wxXmlResource[32], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Domain, &methods_wxXmlResource[8], &methods_wxXmlResource[31], SIP_NULLPTR, SIP_NULLPTR},
};

PyDoc_STRVAR(doc_wxXmlResource, "XmlResource(filemask, flags=XRC_USE_LOCALE, domain='') -> None\n"
"XmlResource(flags=XRC_USE_LOCALE, domain='') -> None\n"
"\n"
"This is the main class for interacting with the XML-based resource\n"
"system.");


sipClassTypeDef sipTypeDef__xrc_wxXmlResource = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SCC|SIP_TYPE_CLASS,
        sipNameNr_wxXmlResource,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        sipNameNr_XmlResource,
        {0, 0, 1},
        34, methods_wxXmlResource,
        0, SIP_NULLPTR,
        3, variables_wxXmlResource,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxXmlResource,
    -1,
    -1,
    supers_wxXmlResource,
    SIP_NULLPTR,
    init_type_wxXmlResource,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_wxXmlResource,
    SIP_NULLPTR,
    array_wxXmlResource,
    SIP_NULLPTR,
    release_wxXmlResource,
    cast_wxXmlResource,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    array_delete_wxXmlResource,
    sizeof (::wxXmlResource),
};
