/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.15.0
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_richtext.h"
        #include <wx/richtext/richtextbuffer.h>
        #include <wx/font.h>
        #include <wx/richtext/richtextbuffer.h>
        #include <wx/object.h>
        #include <wx/object.h>
        #include <wx/object.h>


class sipwxRichTextFontTable : public ::wxRichTextFontTable
{
public:
    sipwxRichTextFontTable();
    sipwxRichTextFontTable(const ::wxRichTextFontTable&);
    ~sipwxRichTextFontTable();

public:
    sipSimpleWrapper *sipPySelf;

private:
    sipwxRichTextFontTable(const sipwxRichTextFontTable &);
    sipwxRichTextFontTable &operator = (const sipwxRichTextFontTable &);
};

sipwxRichTextFontTable::sipwxRichTextFontTable(): ::wxRichTextFontTable(), sipPySelf(SIP_NULLPTR)
{
}

sipwxRichTextFontTable::sipwxRichTextFontTable(const ::wxRichTextFontTable& table): ::wxRichTextFontTable(table), sipPySelf(SIP_NULLPTR)
{
}

sipwxRichTextFontTable::~sipwxRichTextFontTable()
{
    sipInstanceDestroyedEx(&sipPySelf);
}


PyDoc_STRVAR(doc_wxRichTextFontTable_IsOk, "IsOk() -> bool\n"
"\n"
"Returns true if the font table is valid.");

extern "C" {static PyObject *meth_wxRichTextFontTable_IsOk(PyObject *, PyObject *);}
static PyObject *meth_wxRichTextFontTable_IsOk(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxRichTextFontTable *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxRichTextFontTable, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsOk();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_RichTextFontTable, sipName_IsOk, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextFontTable_FindFont, "FindFont(fontSpec) -> wx.Font\n"
"\n"
"Finds a font for the given attribute object.");

extern "C" {static PyObject *meth_wxRichTextFontTable_FindFont(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextFontTable_FindFont(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxRichTextAttr* fontSpec;
        ::wxRichTextFontTable *sipCpp;

        static const char *sipKwdList[] = {
            sipName_fontSpec,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxRichTextFontTable, &sipCpp, sipType_wxRichTextAttr, &fontSpec))
        {
            ::wxFont*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxFont(sipCpp->FindFont(*fontSpec));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxFont, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_RichTextFontTable, sipName_FindFont, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextFontTable_Clear, "Clear() -> None\n"
"\n"
"Clears the font table.");

extern "C" {static PyObject *meth_wxRichTextFontTable_Clear(PyObject *, PyObject *);}
static PyObject *meth_wxRichTextFontTable_Clear(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxRichTextFontTable *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxRichTextFontTable, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->Clear();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_RichTextFontTable, sipName_Clear, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextFontTable_SetFontScale, "SetFontScale(fontScale) -> None\n"
"\n"
"Set the font scale factor.");

extern "C" {static PyObject *meth_wxRichTextFontTable_SetFontScale(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextFontTable_SetFontScale(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        double fontScale;
        ::wxRichTextFontTable *sipCpp;

        static const char *sipKwdList[] = {
            sipName_fontScale,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bd", &sipSelf, sipType_wxRichTextFontTable, &sipCpp, &fontScale))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetFontScale(fontScale);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_RichTextFontTable, sipName_SetFontScale, SIP_NULLPTR);

    return SIP_NULLPTR;
}


extern "C" {static PyObject *slot_wxRichTextFontTable___ne__(PyObject *, PyObject *);}
static PyObject *slot_wxRichTextFontTable___ne__(PyObject *sipSelf, PyObject *sipArg)
{
    ::wxRichTextFontTable *sipCpp = reinterpret_cast< ::wxRichTextFontTable *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_wxRichTextFontTable));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxRichTextFontTable* table;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_wxRichTextFontTable, &table))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->::wxRichTextFontTable::operator!=(*table);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    return sipPySlotExtend(&sipModuleAPI__richtext, ne_slot, sipType_wxRichTextFontTable, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_wxRichTextFontTable___eq__(PyObject *, PyObject *);}
static PyObject *slot_wxRichTextFontTable___eq__(PyObject *sipSelf, PyObject *sipArg)
{
    ::wxRichTextFontTable *sipCpp = reinterpret_cast< ::wxRichTextFontTable *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_wxRichTextFontTable));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxRichTextFontTable* table;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_wxRichTextFontTable, &table))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->::wxRichTextFontTable::operator==(*table);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    return sipPySlotExtend(&sipModuleAPI__richtext, eq_slot, sipType_wxRichTextFontTable, sipSelf, sipArg);
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_wxRichTextFontTable(void *, const sipTypeDef *);}
static void *cast_wxRichTextFontTable(void *sipCppV, const sipTypeDef *targetType)
{
    ::wxRichTextFontTable *sipCpp = reinterpret_cast< ::wxRichTextFontTable *>(sipCppV);

    if (targetType == sipType_wxRichTextFontTable)
        return sipCppV;

    if (targetType == sipType_wxObject)
        return static_cast< ::wxObject *>(sipCpp);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxRichTextFontTable(void *, int);}
static void release_wxRichTextFontTable(void *sipCppV, int sipState)
{
    Py_BEGIN_ALLOW_THREADS

    if (sipState & SIP_DERIVED_CLASS)
        delete reinterpret_cast<sipwxRichTextFontTable *>(sipCppV);
    else
        delete reinterpret_cast< ::wxRichTextFontTable *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void *array_wxRichTextFontTable(Py_ssize_t);}
static void *array_wxRichTextFontTable(Py_ssize_t sipNrElem)
{
    return new ::wxRichTextFontTable[sipNrElem];
}


extern "C" {static void array_delete_wxRichTextFontTable(void *);}
static void array_delete_wxRichTextFontTable(void *sipCpp)
{
    delete[] reinterpret_cast< ::wxRichTextFontTable *>(sipCpp);
}


extern "C" {static void assign_wxRichTextFontTable(void *, Py_ssize_t, void *);}
static void assign_wxRichTextFontTable(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::wxRichTextFontTable *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::wxRichTextFontTable *>(sipSrc);
}


extern "C" {static void *copy_wxRichTextFontTable(const void *, Py_ssize_t);}
static void *copy_wxRichTextFontTable(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new ::wxRichTextFontTable(reinterpret_cast<const ::wxRichTextFontTable *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_wxRichTextFontTable(sipSimpleWrapper *);}
static void dealloc_wxRichTextFontTable(sipSimpleWrapper *sipSelf)
{
    if (sipIsDerivedClass(sipSelf))
        reinterpret_cast<sipwxRichTextFontTable *>(sipGetAddress(sipSelf))->sipPySelf = SIP_NULLPTR;

    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxRichTextFontTable(sipGetAddress(sipSelf), sipIsDerivedClass(sipSelf));
    }
}


extern "C" {static void *init_type_wxRichTextFontTable(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxRichTextFontTable(sipSimpleWrapper *sipSelf, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    sipwxRichTextFontTable *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxRichTextFontTable();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    {
        const ::wxRichTextFontTable* table;

        static const char *sipKwdList[] = {
            sipName_table,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J9", sipType_wxRichTextFontTable, &table))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxRichTextFontTable(*table);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_wxRichTextFontTable[] = {{42, 0, 1}};


/* Define this type's Python slots. */
static sipPySlotDef slots_wxRichTextFontTable[] = {
    {(void *)slot_wxRichTextFontTable___ne__, ne_slot},
    {(void *)slot_wxRichTextFontTable___eq__, eq_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_wxRichTextFontTable[] = {
    {sipName_Clear, meth_wxRichTextFontTable_Clear, METH_VARARGS, doc_wxRichTextFontTable_Clear},
    {sipName_FindFont, SIP_MLMETH_CAST(meth_wxRichTextFontTable_FindFont), METH_VARARGS|METH_KEYWORDS, doc_wxRichTextFontTable_FindFont},
    {sipName_IsOk, meth_wxRichTextFontTable_IsOk, METH_VARARGS, doc_wxRichTextFontTable_IsOk},
    {sipName_SetFontScale, SIP_MLMETH_CAST(meth_wxRichTextFontTable_SetFontScale), METH_VARARGS|METH_KEYWORDS, doc_wxRichTextFontTable_SetFontScale}
};

PyDoc_STRVAR(doc_wxRichTextFontTable, "RichTextFontTable() -> None\n"
"RichTextFontTable(table) -> None\n"
"\n"
"Manages quick access to a pool of fonts for rendering rich text.");


sipClassTypeDef sipTypeDef__richtext_wxRichTextFontTable = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SCC|SIP_TYPE_CLASS,
        sipNameNr_wxRichTextFontTable,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        sipNameNr_RichTextFontTable,
        {0, 0, 1},
        4, methods_wxRichTextFontTable,
        0, SIP_NULLPTR,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxRichTextFontTable,
    -1,
    -1,
    supers_wxRichTextFontTable,
    slots_wxRichTextFontTable,
    init_type_wxRichTextFontTable,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_wxRichTextFontTable,
    assign_wxRichTextFontTable,
    array_wxRichTextFontTable,
    copy_wxRichTextFontTable,
    release_wxRichTextFontTable,
    cast_wxRichTextFontTable,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    array_delete_wxRichTextFontTable,
    sizeof (::wxRichTextFontTable),
};
