/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.15.0
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_html2.h"
        #include <wx/webview.h>



PyDoc_STRVAR(doc_wxWebViewHistoryItem_GetUrl, "GetUrl() -> str");

extern "C" {static PyObject *meth_wxWebViewHistoryItem_GetUrl(PyObject *, PyObject *);}
static PyObject *meth_wxWebViewHistoryItem_GetUrl(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxWebViewHistoryItem *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxWebViewHistoryItem, &sipCpp))
        {
            ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxString(sipCpp->GetUrl());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_WebViewHistoryItem, sipName_GetUrl, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxWebViewHistoryItem_GetTitle, "GetTitle() -> str");

extern "C" {static PyObject *meth_wxWebViewHistoryItem_GetTitle(PyObject *, PyObject *);}
static PyObject *meth_wxWebViewHistoryItem_GetTitle(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxWebViewHistoryItem *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxWebViewHistoryItem, &sipCpp))
        {
            ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxString(sipCpp->GetTitle());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_WebViewHistoryItem, sipName_GetTitle, SIP_NULLPTR);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxWebViewHistoryItem(void *, int);}
static void release_wxWebViewHistoryItem(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxWebViewHistoryItem *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void assign_wxWebViewHistoryItem(void *, Py_ssize_t, void *);}
static void assign_wxWebViewHistoryItem(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::wxWebViewHistoryItem *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::wxWebViewHistoryItem *>(sipSrc);
}


extern "C" {static void *copy_wxWebViewHistoryItem(const void *, Py_ssize_t);}
static void *copy_wxWebViewHistoryItem(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new ::wxWebViewHistoryItem(reinterpret_cast<const ::wxWebViewHistoryItem *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_wxWebViewHistoryItem(sipSimpleWrapper *);}
static void dealloc_wxWebViewHistoryItem(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxWebViewHistoryItem(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxWebViewHistoryItem(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxWebViewHistoryItem(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    ::wxWebViewHistoryItem *sipCpp = SIP_NULLPTR;

    {
        const ::wxString* url;
        int urlState = 0;
        const ::wxString* title;
        int titleState = 0;

        static const char *sipKwdList[] = {
            sipName_url,
            sipName_title,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J1J1", sipType_wxString, &url, &urlState, sipType_wxString, &title, &titleState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new ::wxWebViewHistoryItem(*url, *title);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(url), sipType_wxString, urlState);
            sipReleaseType(const_cast< ::wxString *>(title), sipType_wxString, titleState);

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        const ::wxWebViewHistoryItem* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_wxWebViewHistoryItem, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new ::wxWebViewHistoryItem(*a0);
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


static PyMethodDef methods_wxWebViewHistoryItem[] = {
    {sipName_GetTitle, meth_wxWebViewHistoryItem_GetTitle, METH_VARARGS, doc_wxWebViewHistoryItem_GetTitle},
    {sipName_GetUrl, meth_wxWebViewHistoryItem_GetUrl, METH_VARARGS, doc_wxWebViewHistoryItem_GetUrl}
};

sipVariableDef variables_wxWebViewHistoryItem[] = {
    {PropertyVariable, sipName_Url, &methods_wxWebViewHistoryItem[1], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Title, &methods_wxWebViewHistoryItem[0], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
};

PyDoc_STRVAR(doc_wxWebViewHistoryItem, "WebViewHistoryItem(url, title) -> None\n"
"\n"
"A simple class that contains the URL and title of an element of the\n"
"history of a wxWebView.");


sipClassTypeDef sipTypeDef__html2_wxWebViewHistoryItem = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_CLASS,
        sipNameNr_wxWebViewHistoryItem,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        sipNameNr_WebViewHistoryItem,
        {0, 0, 1},
        2, methods_wxWebViewHistoryItem,
        0, SIP_NULLPTR,
        2, variables_wxWebViewHistoryItem,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxWebViewHistoryItem,
    -1,
    -1,
    SIP_NULLPTR,
    SIP_NULLPTR,
    init_type_wxWebViewHistoryItem,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_wxWebViewHistoryItem,
    assign_wxWebViewHistoryItem,
    SIP_NULLPTR,
    copy_wxWebViewHistoryItem,
    release_wxWebViewHistoryItem,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    sizeof (::wxWebViewHistoryItem),
};
