/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.15.0
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_html2.h"
        #include <wx/webviewfshandler.h>
        #include <wx/filesys.h>


class sipwxWebViewFSHandler : public ::wxWebViewFSHandler
{
public:
    sipwxWebViewFSHandler(const ::wxString&);
    sipwxWebViewFSHandler(const ::wxWebViewFSHandler&);
    virtual ~sipwxWebViewFSHandler();

    /*
     * There is a protected method for every virtual method visible from
     * this class.
     */
protected:
    ::wxFSFile* GetFile(const ::wxString&) SIP_OVERRIDE;
    ::wxString GetName() const SIP_OVERRIDE;
    void SetSecurityURL(const ::wxString&) SIP_OVERRIDE;
    ::wxString GetSecurityURL() const SIP_OVERRIDE;
    void SetVirtualHost(const ::wxString&) SIP_OVERRIDE;
    ::wxString GetVirtualHost() const SIP_OVERRIDE;

public:
    sipSimpleWrapper *sipPySelf;

private:
    sipwxWebViewFSHandler(const sipwxWebViewFSHandler &);
    sipwxWebViewFSHandler &operator = (const sipwxWebViewFSHandler &);

    char sipPyMethods[6];
};

sipwxWebViewFSHandler::sipwxWebViewFSHandler(const ::wxString& scheme): ::wxWebViewFSHandler(scheme), sipPySelf(SIP_NULLPTR)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipwxWebViewFSHandler::sipwxWebViewFSHandler(const ::wxWebViewFSHandler& a0): ::wxWebViewFSHandler(a0), sipPySelf(SIP_NULLPTR)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipwxWebViewFSHandler::~sipwxWebViewFSHandler()
{
    sipInstanceDestroyedEx(&sipPySelf);
}

::wxFSFile* sipwxWebViewFSHandler::GetFile(const ::wxString& uri)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[0], &sipPySelf, SIP_NULLPTR, sipName_GetFile);

    if (!sipMeth)
        return ::wxWebViewFSHandler::GetFile(uri);

    extern ::wxFSFile* sipVH__html2_0(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const ::wxString&);

    return sipVH__html2_0(sipGILState, 0, sipPySelf, sipMeth, uri);
}

::wxString sipwxWebViewFSHandler::GetName() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[1]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_GetName);

    if (!sipMeth)
        return ::wxWebViewFSHandler::GetName();

    extern ::wxString sipVH__html2_1(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__html2_1(sipGILState, 0, sipPySelf, sipMeth);
}

void sipwxWebViewFSHandler::SetSecurityURL(const ::wxString& url)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[2], &sipPySelf, SIP_NULLPTR, sipName_SetSecurityURL);

    if (!sipMeth)
    {
        ::wxWebViewFSHandler::SetSecurityURL(url);
        return;
    }

    extern void sipVH__html2_2(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const ::wxString&);

    sipVH__html2_2(sipGILState, 0, sipPySelf, sipMeth, url);
}

::wxString sipwxWebViewFSHandler::GetSecurityURL() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[3]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_GetSecurityURL);

    if (!sipMeth)
        return ::wxWebViewFSHandler::GetSecurityURL();

    extern ::wxString sipVH__html2_1(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__html2_1(sipGILState, 0, sipPySelf, sipMeth);
}

void sipwxWebViewFSHandler::SetVirtualHost(const ::wxString& host)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[4], &sipPySelf, SIP_NULLPTR, sipName_SetVirtualHost);

    if (!sipMeth)
    {
        ::wxWebViewFSHandler::SetVirtualHost(host);
        return;
    }

    extern void sipVH__html2_2(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const ::wxString&);

    sipVH__html2_2(sipGILState, 0, sipPySelf, sipMeth, host);
}

::wxString sipwxWebViewFSHandler::GetVirtualHost() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[5]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_GetVirtualHost);

    if (!sipMeth)
        return ::wxWebViewFSHandler::GetVirtualHost();

    extern ::wxString sipVH__html2_1(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__html2_1(sipGILState, 0, sipPySelf, sipMeth);
}


PyDoc_STRVAR(doc_wxWebViewFSHandler_GetFile, "GetFile(uri) -> wx.FSFile");

extern "C" {static PyObject *meth_wxWebViewFSHandler_GetFile(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxWebViewFSHandler_GetFile(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const ::wxString* uri;
        int uriState = 0;
        ::wxWebViewFSHandler *sipCpp;

        static const char *sipKwdList[] = {
            sipName_uri,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxWebViewFSHandler, &sipCpp, sipType_wxString, &uri, &uriState))
        {
            ::wxFSFile*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp->::wxWebViewFSHandler::GetFile(*uri) : sipCpp->GetFile(*uri));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(uri), sipType_wxString, uriState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxFSFile, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_WebViewFSHandler, sipName_GetFile, SIP_NULLPTR);

    return SIP_NULLPTR;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_wxWebViewFSHandler(void *, const sipTypeDef *);}
static void *cast_wxWebViewFSHandler(void *sipCppV, const sipTypeDef *targetType)
{
    ::wxWebViewFSHandler *sipCpp = reinterpret_cast< ::wxWebViewFSHandler *>(sipCppV);

    if (targetType == sipType_wxWebViewFSHandler)
        return sipCppV;

    if (targetType == sipType_wxWebViewHandler)
        return static_cast< ::wxWebViewHandler *>(sipCpp);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxWebViewFSHandler(void *, int);}
static void release_wxWebViewFSHandler(void *sipCppV, int sipState)
{
    Py_BEGIN_ALLOW_THREADS

    if (sipState & SIP_DERIVED_CLASS)
        delete reinterpret_cast<sipwxWebViewFSHandler *>(sipCppV);
    else
        delete reinterpret_cast< ::wxWebViewFSHandler *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void assign_wxWebViewFSHandler(void *, Py_ssize_t, void *);}
static void assign_wxWebViewFSHandler(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::wxWebViewFSHandler *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::wxWebViewFSHandler *>(sipSrc);
}


extern "C" {static void *copy_wxWebViewFSHandler(const void *, Py_ssize_t);}
static void *copy_wxWebViewFSHandler(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new ::wxWebViewFSHandler(reinterpret_cast<const ::wxWebViewFSHandler *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_wxWebViewFSHandler(sipSimpleWrapper *);}
static void dealloc_wxWebViewFSHandler(sipSimpleWrapper *sipSelf)
{
    if (sipIsDerivedClass(sipSelf))
        reinterpret_cast<sipwxWebViewFSHandler *>(sipGetAddress(sipSelf))->sipPySelf = SIP_NULLPTR;

    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxWebViewFSHandler(sipGetAddress(sipSelf), sipIsDerivedClass(sipSelf));
    }
}


extern "C" {static void *init_type_wxWebViewFSHandler(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxWebViewFSHandler(sipSimpleWrapper *sipSelf, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    sipwxWebViewFSHandler *sipCpp = SIP_NULLPTR;

    {
        const ::wxString* scheme;
        int schemeState = 0;

        static const char *sipKwdList[] = {
            sipName_scheme,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J1", sipType_wxString, &scheme, &schemeState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxWebViewFSHandler(*scheme);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(scheme), sipType_wxString, schemeState);

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    {
        const ::wxWebViewFSHandler* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_wxWebViewFSHandler, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxWebViewFSHandler(*a0);
            Py_END_ALLOW_THREADS

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_wxWebViewFSHandler[] = {{8, 255, 1}};


static PyMethodDef methods_wxWebViewFSHandler[] = {
    {sipName_GetFile, SIP_MLMETH_CAST(meth_wxWebViewFSHandler_GetFile), METH_VARARGS|METH_KEYWORDS, doc_wxWebViewFSHandler_GetFile}
};

PyDoc_STRVAR(doc_wxWebViewFSHandler, "WebViewFSHandler(scheme) -> None\n"
"\n"
"A wxWebView file system handler to support standard wxFileSystem\n"
"protocols of the form  example:page.htm  The handler allows wxWebView\n"
"to use wxFileSystem in a similar fashion to its use with wxHtml.");


sipClassTypeDef sipTypeDef__html2_wxWebViewFSHandler = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_CLASS,
        sipNameNr_wxWebViewFSHandler,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        sipNameNr_WebViewFSHandler,
        {0, 0, 1},
        1, methods_wxWebViewFSHandler,
        0, SIP_NULLPTR,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxWebViewFSHandler,
    -1,
    -1,
    supers_wxWebViewFSHandler,
    SIP_NULLPTR,
    init_type_wxWebViewFSHandler,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_wxWebViewFSHandler,
    assign_wxWebViewFSHandler,
    SIP_NULLPTR,
    copy_wxWebViewFSHandler,
    release_wxWebViewFSHandler,
    cast_wxWebViewFSHandler,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    sizeof (::wxWebViewFSHandler),
};
