/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.15.0
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"
        #include <wx/cursor.h>
        #include <wx/bmpbndl.h>
        #include <wx/gdicmn.h>
        #include <wx/cursor.h>
        #include <wx/window.h>


PyDoc_STRVAR(doc_wxCursorBundle_IsOk, "IsOk() -> bool\n"
"\n"
"Check if cursor bundle is non-empty.");

extern "C" {static PyObject *meth_wxCursorBundle_IsOk(PyObject *, PyObject *);}
static PyObject *meth_wxCursorBundle_IsOk(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxCursorBundle *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxCursorBundle, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsOk();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_CursorBundle, sipName_IsOk, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxCursorBundle_Clear, "Clear() -> None\n"
"\n"
"Clear the bundle contents.");

extern "C" {static PyObject *meth_wxCursorBundle_Clear(PyObject *, PyObject *);}
static PyObject *meth_wxCursorBundle_Clear(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxCursorBundle *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxCursorBundle, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->Clear();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_CursorBundle, sipName_Clear, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxCursorBundle_GetCursorFor, "GetCursorFor(window) -> Cursor\n"
"\n"
"Get the cursor of the size suitable for the given window.");

extern "C" {static PyObject *meth_wxCursorBundle_GetCursorFor(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxCursorBundle_GetCursorFor(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxWindow* window;
        const ::wxCursorBundle *sipCpp;

        static const char *sipKwdList[] = {
            sipName_window,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ8", &sipSelf, sipType_wxCursorBundle, &sipCpp, sipType_wxWindow, &window))
        {
            ::wxCursor*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxCursor(sipCpp->GetCursorFor(window));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxCursor, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_CursorBundle, sipName_GetCursorFor, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxCursorBundle_GetCursorForMainWindow, "GetCursorForMainWindow() -> Cursor\n"
"\n"
"Get the cursor of the default size.");

extern "C" {static PyObject *meth_wxCursorBundle_GetCursorForMainWindow(PyObject *, PyObject *);}
static PyObject *meth_wxCursorBundle_GetCursorForMainWindow(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxCursorBundle *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxCursorBundle, &sipCpp))
        {
            ::wxCursor*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxCursor(sipCpp->GetCursorForMainWindow());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxCursor, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_CursorBundle, sipName_GetCursorForMainWindow, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxCursorBundle_IsSameAs, "IsSameAs(other) -> bool\n"
"\n"
"Check if two objects refer to the same bundle.");

extern "C" {static PyObject *meth_wxCursorBundle_IsSameAs(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxCursorBundle_IsSameAs(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxCursorBundle* other;
        const ::wxCursorBundle *sipCpp;

        static const char *sipKwdList[] = {
            sipName_other,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxCursorBundle, &sipCpp, sipType_wxCursorBundle, &other))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsSameAs(*other);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_CursorBundle, sipName_IsSameAs, SIP_NULLPTR);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxCursorBundle(void *, int);}
static void release_wxCursorBundle(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxCursorBundle *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void *array_wxCursorBundle(Py_ssize_t);}
static void *array_wxCursorBundle(Py_ssize_t sipNrElem)
{
    return new ::wxCursorBundle[sipNrElem];
}


extern "C" {static void array_delete_wxCursorBundle(void *);}
static void array_delete_wxCursorBundle(void *sipCpp)
{
    delete[] reinterpret_cast< ::wxCursorBundle *>(sipCpp);
}


extern "C" {static void assign_wxCursorBundle(void *, Py_ssize_t, void *);}
static void assign_wxCursorBundle(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::wxCursorBundle *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::wxCursorBundle *>(sipSrc);
}


extern "C" {static void *copy_wxCursorBundle(const void *, Py_ssize_t);}
static void *copy_wxCursorBundle(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new ::wxCursorBundle(reinterpret_cast<const ::wxCursorBundle *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_wxCursorBundle(sipSimpleWrapper *);}
static void dealloc_wxCursorBundle(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxCursorBundle(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxCursorBundle(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxCursorBundle(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    ::wxCursorBundle *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new ::wxCursorBundle();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        const ::wxBitmapBundle* bitmaps;
        int bitmapsState = 0;
        const ::wxPoint* hotSpot;
        int hotSpotState = 0;

        static const char *sipKwdList[] = {
            sipName_bitmaps,
            sipName_hotSpot,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J1J1", sipType_wxBitmapBundle, &bitmaps, &bitmapsState, sipType_wxPoint, &hotSpot, &hotSpotState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new ::wxCursorBundle(*bitmaps, *hotSpot);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxBitmapBundle *>(bitmaps), sipType_wxBitmapBundle, bitmapsState);
            sipReleaseType(const_cast< ::wxPoint *>(hotSpot), sipType_wxPoint, hotSpotState);

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        const ::wxBitmapBundle* bitmaps;
        int bitmapsState = 0;
        int hotSpotX = 0;
        int hotSpotY = 0;

        static const char *sipKwdList[] = {
            sipName_bitmaps,
            sipName_hotSpotX,
            sipName_hotSpotY,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J1|ii", sipType_wxBitmapBundle, &bitmaps, &bitmapsState, &hotSpotX, &hotSpotY))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new ::wxCursorBundle(*bitmaps, hotSpotX, hotSpotY);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxBitmapBundle *>(bitmaps), sipType_wxBitmapBundle, bitmapsState);

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        const ::wxCursorBundle* other;

        static const char *sipKwdList[] = {
            sipName_other,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J9", sipType_wxCursorBundle, &other))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new ::wxCursorBundle(*other);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


static PyMethodDef methods_wxCursorBundle[] = {
    {sipName_Clear, meth_wxCursorBundle_Clear, METH_VARARGS, doc_wxCursorBundle_Clear},
    {sipName_GetCursorFor, SIP_MLMETH_CAST(meth_wxCursorBundle_GetCursorFor), METH_VARARGS|METH_KEYWORDS, doc_wxCursorBundle_GetCursorFor},
    {sipName_GetCursorForMainWindow, meth_wxCursorBundle_GetCursorForMainWindow, METH_VARARGS, doc_wxCursorBundle_GetCursorForMainWindow},
    {sipName_IsOk, meth_wxCursorBundle_IsOk, METH_VARARGS, doc_wxCursorBundle_IsOk},
    {sipName_IsSameAs, SIP_MLMETH_CAST(meth_wxCursorBundle_IsSameAs), METH_VARARGS|METH_KEYWORDS, doc_wxCursorBundle_IsSameAs}
};

sipVariableDef variables_wxCursorBundle[] = {
    {PropertyVariable, sipName_CursorForMainWindow, &methods_wxCursorBundle[2], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
};

PyDoc_STRVAR(doc_wxCursorBundle, "CursorBundle() -> None\n"
"CursorBundle(bitmaps, hotSpot) -> None\n"
"CursorBundle(bitmaps, hotSpotX=0, hotSpotY=0) -> None\n"
"CursorBundle(other) -> None\n"
"\n"
"A cursor bundle is a set of different versions of the same cursor at\n"
"different sizes.");


sipClassTypeDef sipTypeDef__core_wxCursorBundle = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_CLASS,
        sipNameNr_wxCursorBundle,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        sipNameNr_CursorBundle,
        {0, 0, 1},
        5, methods_wxCursorBundle,
        0, SIP_NULLPTR,
        1, variables_wxCursorBundle,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxCursorBundle,
    -1,
    -1,
    SIP_NULLPTR,
    SIP_NULLPTR,
    init_type_wxCursorBundle,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_wxCursorBundle,
    assign_wxCursorBundle,
    array_wxCursorBundle,
    copy_wxCursorBundle,
    release_wxCursorBundle,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    array_delete_wxCursorBundle,
    sizeof (::wxCursorBundle),
};
