/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.15.0
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_adv.h"
        #include <wx/animate.h>
        #include <wx/animate.h>
    #include <vector>


PyDoc_STRVAR(doc_wxAnimationBundle_Add, "Add(anim) -> None\n"
"Add(filename, type=ANIMATION_TYPE_ANY) -> None\n"
"\n"
"Add an animation in another, bigger, size.\n"
"");

extern "C" {static PyObject *meth_wxAnimationBundle_Add(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAnimationBundle_Add(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxAnimation* anim;
        ::wxAnimationBundle *sipCpp;

        static const char *sipKwdList[] = {
            sipName_anim,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxAnimationBundle, &sipCpp, sipType_wxAnimation, &anim))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->Add(*anim);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const ::wxString* filename;
        int filenameState = 0;
        ::wxAnimationType type = wxANIMATION_TYPE_ANY;
        ::wxAnimationBundle *sipCpp;

        static const char *sipKwdList[] = {
            sipName_filename,
            sipName_type,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1|E", &sipSelf, sipType_wxAnimationBundle, &sipCpp, sipType_wxString, &filename, &filenameState, sipType_wxAnimationType, &type))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->Add(*filename, type);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(filename), sipType_wxString, filenameState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_AnimationBundle, sipName_Add, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAnimationBundle_GetAll, "GetAll() -> std.vectorwxAnimation\n"
"\n"
"Get vector containing all animations in this bundle.");

extern "C" {static PyObject *meth_wxAnimationBundle_GetAll(PyObject *, PyObject *);}
static PyObject *meth_wxAnimationBundle_GetAll(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxAnimationBundle *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAnimationBundle, &sipCpp))
        {
            std::vector< ::wxAnimation>*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new std::vector< ::wxAnimation>(sipCpp->GetAll());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_std_vector_0100wxAnimation, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_AnimationBundle, sipName_GetAll, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAnimationBundle_IsOk, "IsOk() -> bool\n"
"\n"
"Return true if this animation bundle is not empty.");

extern "C" {static PyObject *meth_wxAnimationBundle_IsOk(PyObject *, PyObject *);}
static PyObject *meth_wxAnimationBundle_IsOk(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxAnimationBundle *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAnimationBundle, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsOk();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_AnimationBundle, sipName_IsOk, SIP_NULLPTR);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxAnimationBundle(void *, int);}
static void release_wxAnimationBundle(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxAnimationBundle *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void *array_wxAnimationBundle(Py_ssize_t);}
static void *array_wxAnimationBundle(Py_ssize_t sipNrElem)
{
    return new ::wxAnimationBundle[sipNrElem];
}


extern "C" {static void array_delete_wxAnimationBundle(void *);}
static void array_delete_wxAnimationBundle(void *sipCpp)
{
    delete[] reinterpret_cast< ::wxAnimationBundle *>(sipCpp);
}


extern "C" {static void assign_wxAnimationBundle(void *, Py_ssize_t, void *);}
static void assign_wxAnimationBundle(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::wxAnimationBundle *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::wxAnimationBundle *>(sipSrc);
}


extern "C" {static void *copy_wxAnimationBundle(const void *, Py_ssize_t);}
static void *copy_wxAnimationBundle(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new ::wxAnimationBundle(reinterpret_cast<const ::wxAnimationBundle *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_wxAnimationBundle(sipSimpleWrapper *);}
static void dealloc_wxAnimationBundle(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxAnimationBundle(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxAnimationBundle(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxAnimationBundle(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    ::wxAnimationBundle *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new ::wxAnimationBundle();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        const ::wxAnimation* anim;

        static const char *sipKwdList[] = {
            sipName_anim,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J9", sipType_wxAnimation, &anim))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new ::wxAnimationBundle(*anim);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        const ::wxString* filename;
        int filenameState = 0;
        ::wxAnimationType type = wxANIMATION_TYPE_ANY;

        static const char *sipKwdList[] = {
            sipName_filename,
            sipName_type,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J1|E", sipType_wxString, &filename, &filenameState, sipType_wxAnimationType, &type))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new ::wxAnimationBundle(*filename, type);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(filename), sipType_wxString, filenameState);

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        const ::wxAnimationBundle* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_wxAnimationBundle, &a0))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new ::wxAnimationBundle(*a0);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


static PyMethodDef methods_wxAnimationBundle[] = {
    {sipName_Add, SIP_MLMETH_CAST(meth_wxAnimationBundle_Add), METH_VARARGS|METH_KEYWORDS, doc_wxAnimationBundle_Add},
    {sipName_GetAll, meth_wxAnimationBundle_GetAll, METH_VARARGS, doc_wxAnimationBundle_GetAll},
    {sipName_IsOk, meth_wxAnimationBundle_IsOk, METH_VARARGS, doc_wxAnimationBundle_IsOk}
};

sipVariableDef variables_wxAnimationBundle[] = {
    {PropertyVariable, sipName_All, &methods_wxAnimationBundle[1], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
};

PyDoc_STRVAR(doc_wxAnimationBundle, "AnimationBundle() -> None\n"
"AnimationBundle(anim) -> None\n"
"AnimationBundle(filename, type=ANIMATION_TYPE_ANY) -> None\n"
"AnimationBundle() -> None\n"
"\n"
"Container for possible multiple versions of the same animation in\n"
"different resolutions.");


sipClassTypeDef sipTypeDef__adv_wxAnimationBundle = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_CLASS,
        sipNameNr_wxAnimationBundle,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        sipNameNr_AnimationBundle,
        {0, 0, 1},
        3, methods_wxAnimationBundle,
        0, SIP_NULLPTR,
        1, variables_wxAnimationBundle,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxAnimationBundle,
    -1,
    -1,
    SIP_NULLPTR,
    SIP_NULLPTR,
    init_type_wxAnimationBundle,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_wxAnimationBundle,
    assign_wxAnimationBundle,
    array_wxAnimationBundle,
    copy_wxAnimationBundle,
    release_wxAnimationBundle,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    array_delete_wxAnimationBundle,
    sizeof (::wxAnimationBundle),
};
