/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.15.0
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"
        #include <wx/event.h>
        #include <wx/event.h>
        #include <wx/window.h>
        #include <wx/object.h>
        #include <wx/object.h>
        #include <wx/object.h>


class sipwxNavigationKeyEvent : public ::wxNavigationKeyEvent
{
public:
    sipwxNavigationKeyEvent();
    sipwxNavigationKeyEvent(const ::wxNavigationKeyEvent&);
    virtual ~sipwxNavigationKeyEvent();

    /*
     * There is a protected method for every virtual method visible from
     * this class.
     */
protected:
    ::wxEvent* Clone() const SIP_OVERRIDE;
    ::wxEventCategory GetEventCategory() const SIP_OVERRIDE;

public:
    sipSimpleWrapper *sipPySelf;

private:
    sipwxNavigationKeyEvent(const sipwxNavigationKeyEvent &);
    sipwxNavigationKeyEvent &operator = (const sipwxNavigationKeyEvent &);

    char sipPyMethods[2];
};

sipwxNavigationKeyEvent::sipwxNavigationKeyEvent(): ::wxNavigationKeyEvent(), sipPySelf(SIP_NULLPTR)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipwxNavigationKeyEvent::sipwxNavigationKeyEvent(const ::wxNavigationKeyEvent& event): ::wxNavigationKeyEvent(event), sipPySelf(SIP_NULLPTR)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipwxNavigationKeyEvent::~sipwxNavigationKeyEvent()
{
    sipInstanceDestroyedEx(&sipPySelf);
}

::wxEvent* sipwxNavigationKeyEvent::Clone() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[0]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_Clone);

    if (!sipMeth)
        return ::wxNavigationKeyEvent::Clone();

    extern ::wxEvent* sipVH__core_103(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_103(sipGILState, 0, sipPySelf, sipMeth);
}

::wxEventCategory sipwxNavigationKeyEvent::GetEventCategory() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[1]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_GetEventCategory);

    if (!sipMeth)
        return ::wxNavigationKeyEvent::GetEventCategory();

    extern ::wxEventCategory sipVH__core_104(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_104(sipGILState, 0, sipPySelf, sipMeth);
}


PyDoc_STRVAR(doc_wxNavigationKeyEvent_GetCurrentFocus, "GetCurrentFocus() -> Window\n"
"\n"
"Returns the child that has the focus, or NULL.");

extern "C" {static PyObject *meth_wxNavigationKeyEvent_GetCurrentFocus(PyObject *, PyObject *);}
static PyObject *meth_wxNavigationKeyEvent_GetCurrentFocus(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxNavigationKeyEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxNavigationKeyEvent, &sipCpp))
        {
            ::wxWindow*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetCurrentFocus();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes, sipType_wxWindow, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_NavigationKeyEvent, sipName_GetCurrentFocus, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxNavigationKeyEvent_GetDirection, "GetDirection() -> bool\n"
"\n"
"Returns true if the navigation was in the forward direction.");

extern "C" {static PyObject *meth_wxNavigationKeyEvent_GetDirection(PyObject *, PyObject *);}
static PyObject *meth_wxNavigationKeyEvent_GetDirection(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxNavigationKeyEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxNavigationKeyEvent, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetDirection();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_NavigationKeyEvent, sipName_GetDirection, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxNavigationKeyEvent_IsFromTab, "IsFromTab() -> bool\n"
"\n"
"Returns true if the navigation event was from a tab key.");

extern "C" {static PyObject *meth_wxNavigationKeyEvent_IsFromTab(PyObject *, PyObject *);}
static PyObject *meth_wxNavigationKeyEvent_IsFromTab(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxNavigationKeyEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxNavigationKeyEvent, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsFromTab();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_NavigationKeyEvent, sipName_IsFromTab, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxNavigationKeyEvent_IsWindowChange, "IsWindowChange() -> bool\n"
"\n"
"Returns true if the navigation event represents a window change (for\n"
"example, from Ctrl-Page Down in a notebook).");

extern "C" {static PyObject *meth_wxNavigationKeyEvent_IsWindowChange(PyObject *, PyObject *);}
static PyObject *meth_wxNavigationKeyEvent_IsWindowChange(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxNavigationKeyEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxNavigationKeyEvent, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsWindowChange();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_NavigationKeyEvent, sipName_IsWindowChange, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxNavigationKeyEvent_SetCurrentFocus, "SetCurrentFocus(currentFocus) -> None\n"
"\n"
"Sets the current focus window member.");

extern "C" {static PyObject *meth_wxNavigationKeyEvent_SetCurrentFocus(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxNavigationKeyEvent_SetCurrentFocus(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxWindow* currentFocus;
        ::wxNavigationKeyEvent *sipCpp;

        static const char *sipKwdList[] = {
            sipName_currentFocus,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ8", &sipSelf, sipType_wxNavigationKeyEvent, &sipCpp, sipType_wxWindow, &currentFocus))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetCurrentFocus(currentFocus);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_NavigationKeyEvent, sipName_SetCurrentFocus, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxNavigationKeyEvent_SetDirection, "SetDirection(direction) -> None\n"
"\n"
"Sets the direction to forward if direction is true, or backward if\n"
"false.");

extern "C" {static PyObject *meth_wxNavigationKeyEvent_SetDirection(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxNavigationKeyEvent_SetDirection(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool direction;
        ::wxNavigationKeyEvent *sipCpp;

        static const char *sipKwdList[] = {
            sipName_direction,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bb", &sipSelf, sipType_wxNavigationKeyEvent, &sipCpp, &direction))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetDirection(direction);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_NavigationKeyEvent, sipName_SetDirection, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxNavigationKeyEvent_SetFlags, "SetFlags(flags) -> None\n"
"\n"
"Sets the flags for this event.");

extern "C" {static PyObject *meth_wxNavigationKeyEvent_SetFlags(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxNavigationKeyEvent_SetFlags(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        long flags;
        ::wxNavigationKeyEvent *sipCpp;

        static const char *sipKwdList[] = {
            sipName_flags,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bl", &sipSelf, sipType_wxNavigationKeyEvent, &sipCpp, &flags))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetFlags(flags);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_NavigationKeyEvent, sipName_SetFlags, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxNavigationKeyEvent_SetFromTab, "SetFromTab(fromTab) -> None\n"
"\n"
"Marks the navigation event as from a tab key.");

extern "C" {static PyObject *meth_wxNavigationKeyEvent_SetFromTab(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxNavigationKeyEvent_SetFromTab(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool fromTab;
        ::wxNavigationKeyEvent *sipCpp;

        static const char *sipKwdList[] = {
            sipName_fromTab,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bb", &sipSelf, sipType_wxNavigationKeyEvent, &sipCpp, &fromTab))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetFromTab(fromTab);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_NavigationKeyEvent, sipName_SetFromTab, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxNavigationKeyEvent_SetWindowChange, "SetWindowChange(windowChange) -> None\n"
"\n"
"Marks the event as a window change event.");

extern "C" {static PyObject *meth_wxNavigationKeyEvent_SetWindowChange(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxNavigationKeyEvent_SetWindowChange(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool windowChange;
        ::wxNavigationKeyEvent *sipCpp;

        static const char *sipKwdList[] = {
            sipName_windowChange,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bb", &sipSelf, sipType_wxNavigationKeyEvent, &sipCpp, &windowChange))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetWindowChange(windowChange);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_NavigationKeyEvent, sipName_SetWindowChange, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxNavigationKeyEvent_Clone, "Clone(self) -> Event|None");

extern "C" {static PyObject *meth_wxNavigationKeyEvent_Clone(PyObject *, PyObject *);}
static PyObject *meth_wxNavigationKeyEvent_Clone(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const ::wxNavigationKeyEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxNavigationKeyEvent, &sipCpp))
        {
            ::wxEvent*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp->::wxNavigationKeyEvent::Clone() : sipCpp->Clone());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxEvent, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_NavigationKeyEvent, sipName_Clone, doc_wxNavigationKeyEvent_Clone);

    return SIP_NULLPTR;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_wxNavigationKeyEvent(void *, const sipTypeDef *);}
static void *cast_wxNavigationKeyEvent(void *sipCppV, const sipTypeDef *targetType)
{
    ::wxNavigationKeyEvent *sipCpp = reinterpret_cast< ::wxNavigationKeyEvent *>(sipCppV);

    if (targetType == sipType_wxNavigationKeyEvent)
        return sipCppV;

    sipCppV = ((const sipClassTypeDef *)sipType_wxEvent)->ctd_cast(static_cast< ::wxEvent *>(sipCpp), targetType);
    if (sipCppV)
        return sipCppV;

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxNavigationKeyEvent(void *, int);}
static void release_wxNavigationKeyEvent(void *sipCppV, int sipState)
{
    Py_BEGIN_ALLOW_THREADS

    if (sipState & SIP_DERIVED_CLASS)
        delete reinterpret_cast<sipwxNavigationKeyEvent *>(sipCppV);
    else
        delete reinterpret_cast< ::wxNavigationKeyEvent *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void dealloc_wxNavigationKeyEvent(sipSimpleWrapper *);}
static void dealloc_wxNavigationKeyEvent(sipSimpleWrapper *sipSelf)
{
    if (sipIsDerivedClass(sipSelf))
        reinterpret_cast<sipwxNavigationKeyEvent *>(sipGetAddress(sipSelf))->sipPySelf = SIP_NULLPTR;

    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxNavigationKeyEvent(sipGetAddress(sipSelf), sipIsDerivedClass(sipSelf));
    }
}


extern "C" {static void *init_type_wxNavigationKeyEvent(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxNavigationKeyEvent(sipSimpleWrapper *sipSelf, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    sipwxNavigationKeyEvent *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxNavigationKeyEvent();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    {
        const ::wxNavigationKeyEvent* event;

        static const char *sipKwdList[] = {
            sipName_event,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J9", sipType_wxNavigationKeyEvent, &event))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxNavigationKeyEvent(*event);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_wxNavigationKeyEvent[] = {{151, 255, 1}};


static PyMethodDef methods_wxNavigationKeyEvent[] = {
    {sipName_Clone, meth_wxNavigationKeyEvent_Clone, METH_VARARGS, doc_wxNavigationKeyEvent_Clone},
    {sipName_GetCurrentFocus, meth_wxNavigationKeyEvent_GetCurrentFocus, METH_VARARGS, doc_wxNavigationKeyEvent_GetCurrentFocus},
    {sipName_GetDirection, meth_wxNavigationKeyEvent_GetDirection, METH_VARARGS, doc_wxNavigationKeyEvent_GetDirection},
    {sipName_IsFromTab, meth_wxNavigationKeyEvent_IsFromTab, METH_VARARGS, doc_wxNavigationKeyEvent_IsFromTab},
    {sipName_IsWindowChange, meth_wxNavigationKeyEvent_IsWindowChange, METH_VARARGS, doc_wxNavigationKeyEvent_IsWindowChange},
    {sipName_SetCurrentFocus, SIP_MLMETH_CAST(meth_wxNavigationKeyEvent_SetCurrentFocus), METH_VARARGS|METH_KEYWORDS, doc_wxNavigationKeyEvent_SetCurrentFocus},
    {sipName_SetDirection, SIP_MLMETH_CAST(meth_wxNavigationKeyEvent_SetDirection), METH_VARARGS|METH_KEYWORDS, doc_wxNavigationKeyEvent_SetDirection},
    {sipName_SetFlags, SIP_MLMETH_CAST(meth_wxNavigationKeyEvent_SetFlags), METH_VARARGS|METH_KEYWORDS, doc_wxNavigationKeyEvent_SetFlags},
    {sipName_SetFromTab, SIP_MLMETH_CAST(meth_wxNavigationKeyEvent_SetFromTab), METH_VARARGS|METH_KEYWORDS, doc_wxNavigationKeyEvent_SetFromTab},
    {sipName_SetWindowChange, SIP_MLMETH_CAST(meth_wxNavigationKeyEvent_SetWindowChange), METH_VARARGS|METH_KEYWORDS, doc_wxNavigationKeyEvent_SetWindowChange}
};

static sipEnumMemberDef enummembers_wxNavigationKeyEvent[] = {
    {sipName_FromTab, static_cast<int>(::wxNavigationKeyEvent::FromTab), 387},
    {sipName_IsBackward, static_cast<int>(::wxNavigationKeyEvent::IsBackward), 387},
    {sipName_IsForward, static_cast<int>(::wxNavigationKeyEvent::IsForward), 387},
    {sipName_WinChange, static_cast<int>(::wxNavigationKeyEvent::WinChange), 387},
};

sipVariableDef variables_wxNavigationKeyEvent[] = {
    {PropertyVariable, sipName_Direction, &methods_wxNavigationKeyEvent[2], &methods_wxNavigationKeyEvent[6], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_CurrentFocus, &methods_wxNavigationKeyEvent[1], &methods_wxNavigationKeyEvent[5], SIP_NULLPTR, SIP_NULLPTR},
};

PyDoc_STRVAR(doc_wxNavigationKeyEvent, "NavigationKeyEvent() -> None\n"
"NavigationKeyEvent(event) -> None\n"
"\n"
"This event class contains information about navigation events,\n"
"generated by navigation keys such as tab and page down.");


sipClassTypeDef sipTypeDef__core_wxNavigationKeyEvent = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SCC|SIP_TYPE_CLASS,
        sipNameNr_wxNavigationKeyEvent,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        sipNameNr_NavigationKeyEvent,
        {0, 0, 1},
        10, methods_wxNavigationKeyEvent,
        4, enummembers_wxNavigationKeyEvent,
        2, variables_wxNavigationKeyEvent,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxNavigationKeyEvent,
    -1,
    -1,
    supers_wxNavigationKeyEvent,
    SIP_NULLPTR,
    init_type_wxNavigationKeyEvent,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_wxNavigationKeyEvent,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    release_wxNavigationKeyEvent,
    cast_wxNavigationKeyEvent,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    sizeof (::wxNavigationKeyEvent),
};
