/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.15.0
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"
        #include <wx/graphics.h>
        #include <wx/colour.h>


PyDoc_STRVAR(doc_wxGraphicsGradientStop_GetColour, "GetColour() -> Colour\n"
"\n"
"Return the stop colour.");

extern "C" {static PyObject *meth_wxGraphicsGradientStop_GetColour(PyObject *, PyObject *);}
static PyObject *meth_wxGraphicsGradientStop_GetColour(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxGraphicsGradientStop *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxGraphicsGradientStop, &sipCpp))
        {
            ::wxColour*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxColour(sipCpp->GetColour());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxColour, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_GraphicsGradientStop, sipName_GetColour, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxGraphicsGradientStop_SetColour, "SetColour(col) -> None\n"
"\n"
"Change the stop colour.");

extern "C" {static PyObject *meth_wxGraphicsGradientStop_SetColour(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGraphicsGradientStop_SetColour(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxColour* col;
        int colState = 0;
        ::wxGraphicsGradientStop *sipCpp;

        static const char *sipKwdList[] = {
            sipName_col,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxGraphicsGradientStop, &sipCpp, sipType_wxColour, &col, &colState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetColour(*col);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxColour *>(col), sipType_wxColour, colState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_GraphicsGradientStop, sipName_SetColour, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxGraphicsGradientStop_GetPosition, "GetPosition() -> float\n"
"\n"
"Return the stop position.");

extern "C" {static PyObject *meth_wxGraphicsGradientStop_GetPosition(PyObject *, PyObject *);}
static PyObject *meth_wxGraphicsGradientStop_GetPosition(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxGraphicsGradientStop *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxGraphicsGradientStop, &sipCpp))
        {
            float sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetPosition();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyFloat_FromDouble((double)sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_GraphicsGradientStop, sipName_GetPosition, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxGraphicsGradientStop_SetPosition, "SetPosition(pos) -> None\n"
"\n"
"Change the stop position.");

extern "C" {static PyObject *meth_wxGraphicsGradientStop_SetPosition(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGraphicsGradientStop_SetPosition(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        float pos;
        ::wxGraphicsGradientStop *sipCpp;

        static const char *sipKwdList[] = {
            sipName_pos,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bf", &sipSelf, sipType_wxGraphicsGradientStop, &sipCpp, &pos))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetPosition(pos);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_GraphicsGradientStop, sipName_SetPosition, SIP_NULLPTR);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxGraphicsGradientStop(void *, int);}
static void release_wxGraphicsGradientStop(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxGraphicsGradientStop *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void *array_wxGraphicsGradientStop(Py_ssize_t);}
static void *array_wxGraphicsGradientStop(Py_ssize_t sipNrElem)
{
    return new ::wxGraphicsGradientStop[sipNrElem];
}


extern "C" {static void array_delete_wxGraphicsGradientStop(void *);}
static void array_delete_wxGraphicsGradientStop(void *sipCpp)
{
    delete[] reinterpret_cast< ::wxGraphicsGradientStop *>(sipCpp);
}


extern "C" {static void assign_wxGraphicsGradientStop(void *, Py_ssize_t, void *);}
static void assign_wxGraphicsGradientStop(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::wxGraphicsGradientStop *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::wxGraphicsGradientStop *>(sipSrc);
}


extern "C" {static void *copy_wxGraphicsGradientStop(const void *, Py_ssize_t);}
static void *copy_wxGraphicsGradientStop(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new ::wxGraphicsGradientStop(reinterpret_cast<const ::wxGraphicsGradientStop *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_wxGraphicsGradientStop(sipSimpleWrapper *);}
static void dealloc_wxGraphicsGradientStop(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxGraphicsGradientStop(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxGraphicsGradientStop(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxGraphicsGradientStop(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    ::wxGraphicsGradientStop *sipCpp = SIP_NULLPTR;

    {
        ::wxColour coldef = wxTransparentColour;
        ::wxColour* col = &coldef;
        int colState = 0;
        float pos = 0;

        static const char *sipKwdList[] = {
            sipName_col,
            sipName_pos,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "|J1f", sipType_wxColour, &col, &colState, &pos))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new ::wxGraphicsGradientStop(*col, pos);
            Py_END_ALLOW_THREADS
            sipReleaseType(col, sipType_wxColour, colState);

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        const ::wxGraphicsGradientStop* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_wxGraphicsGradientStop, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new ::wxGraphicsGradientStop(*a0);
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


static PyMethodDef methods_wxGraphicsGradientStop[] = {
    {sipName_GetColour, meth_wxGraphicsGradientStop_GetColour, METH_VARARGS, doc_wxGraphicsGradientStop_GetColour},
    {sipName_GetPosition, meth_wxGraphicsGradientStop_GetPosition, METH_VARARGS, doc_wxGraphicsGradientStop_GetPosition},
    {sipName_SetColour, SIP_MLMETH_CAST(meth_wxGraphicsGradientStop_SetColour), METH_VARARGS|METH_KEYWORDS, doc_wxGraphicsGradientStop_SetColour},
    {sipName_SetPosition, SIP_MLMETH_CAST(meth_wxGraphicsGradientStop_SetPosition), METH_VARARGS|METH_KEYWORDS, doc_wxGraphicsGradientStop_SetPosition}
};

sipVariableDef variables_wxGraphicsGradientStop[] = {
    {PropertyVariable, sipName_Position, &methods_wxGraphicsGradientStop[1], &methods_wxGraphicsGradientStop[3], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Colour, &methods_wxGraphicsGradientStop[0], &methods_wxGraphicsGradientStop[2], SIP_NULLPTR, SIP_NULLPTR},
};

PyDoc_STRVAR(doc_wxGraphicsGradientStop, "GraphicsGradientStop(col=TransparentColour, pos=0.) -> None\n"
"\n"
"Represents a single gradient stop in a collection of gradient stops as\n"
"represented by wxGraphicsGradientStops.");


sipClassTypeDef sipTypeDef__core_wxGraphicsGradientStop = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_CLASS,
        sipNameNr_wxGraphicsGradientStop,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        sipNameNr_GraphicsGradientStop,
        {0, 0, 1},
        4, methods_wxGraphicsGradientStop,
        0, SIP_NULLPTR,
        2, variables_wxGraphicsGradientStop,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxGraphicsGradientStop,
    -1,
    -1,
    SIP_NULLPTR,
    SIP_NULLPTR,
    init_type_wxGraphicsGradientStop,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_wxGraphicsGradientStop,
    assign_wxGraphicsGradientStop,
    array_wxGraphicsGradientStop,
    copy_wxGraphicsGradientStop,
    release_wxGraphicsGradientStop,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    array_delete_wxGraphicsGradientStop,
    sizeof (::wxGraphicsGradientStop),
};
