/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.12.0
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"
        #include <wx/event.h>
        #include <wx/gdicmn.h>
        #include <wx/event.h>
        #include <wx/object.h>
        #include <wx/object.h>
        #include <wx/object.h>


class sipwxContextMenuEvent : public ::wxContextMenuEvent
{
public:
    sipwxContextMenuEvent(::wxEventType, int, const ::wxPoint&);
    sipwxContextMenuEvent(const ::wxContextMenuEvent&);
    virtual ~sipwxContextMenuEvent();

    /*
     * There is a protected method for every virtual method visible from
     * this class.
     */
protected:
    ::wxEventCategory GetEventCategory() const SIP_OVERRIDE;
    ::wxEvent* Clone() const SIP_OVERRIDE;

public:
    sipSimpleWrapper *sipPySelf;

private:
    sipwxContextMenuEvent(const sipwxContextMenuEvent &);
    sipwxContextMenuEvent &operator = (const sipwxContextMenuEvent &);

    char sipPyMethods[2];
};

sipwxContextMenuEvent::sipwxContextMenuEvent(::wxEventType type, int id, const ::wxPoint& pos): ::wxContextMenuEvent(type, id, pos), sipPySelf(SIP_NULLPTR)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipwxContextMenuEvent::sipwxContextMenuEvent(const ::wxContextMenuEvent& a0): ::wxContextMenuEvent(a0), sipPySelf(SIP_NULLPTR)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipwxContextMenuEvent::~sipwxContextMenuEvent()
{
    sipInstanceDestroyedEx(&sipPySelf);
}

::wxEventCategory sipwxContextMenuEvent::GetEventCategory() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[0]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_GetEventCategory);

    if (!sipMeth)
        return ::wxContextMenuEvent::GetEventCategory();

    extern ::wxEventCategory sipVH__core_104(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_104(sipGILState, 0, sipPySelf, sipMeth);
}

::wxEvent* sipwxContextMenuEvent::Clone() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[1]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_Clone);

    if (!sipMeth)
        return ::wxContextMenuEvent::Clone();

    extern ::wxEvent* sipVH__core_103(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_103(sipGILState, 0, sipPySelf, sipMeth);
}


PyDoc_STRVAR(doc_wxContextMenuEvent_GetPosition, "GetPosition() -> Point\n"
"\n"
"Returns the position in screen coordinates at which the menu should be\n"
"shown.");

extern "C" {static PyObject *meth_wxContextMenuEvent_GetPosition(PyObject *, PyObject *);}
static PyObject *meth_wxContextMenuEvent_GetPosition(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxContextMenuEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxContextMenuEvent, &sipCpp))
        {
            ::wxPoint*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxPoint(sipCpp->GetPosition());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxPoint, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_ContextMenuEvent, sipName_GetPosition, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxContextMenuEvent_SetPosition, "SetPosition(point) -> None\n"
"\n"
"Sets the position at which the menu should be shown.");

extern "C" {static PyObject *meth_wxContextMenuEvent_SetPosition(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxContextMenuEvent_SetPosition(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxPoint* point;
        int pointState = 0;
        ::wxContextMenuEvent *sipCpp;

        static const char *sipKwdList[] = {
            sipName_point,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxContextMenuEvent, &sipCpp, sipType_wxPoint, &point, &pointState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetPosition(*point);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPoint *>(point), sipType_wxPoint, pointState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_ContextMenuEvent, sipName_SetPosition, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxContextMenuEvent_Clone, "Clone(self) -> Optional[Event]");

extern "C" {static PyObject *meth_wxContextMenuEvent_Clone(PyObject *, PyObject *);}
static PyObject *meth_wxContextMenuEvent_Clone(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const ::wxContextMenuEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxContextMenuEvent, &sipCpp))
        {
            ::wxEvent*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp->::wxContextMenuEvent::Clone() : sipCpp->Clone());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxEvent, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_ContextMenuEvent, sipName_Clone, doc_wxContextMenuEvent_Clone);

    return SIP_NULLPTR;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_wxContextMenuEvent(void *, const sipTypeDef *);}
static void *cast_wxContextMenuEvent(void *sipCppV, const sipTypeDef *targetType)
{
    ::wxContextMenuEvent *sipCpp = reinterpret_cast< ::wxContextMenuEvent *>(sipCppV);

    if (targetType == sipType_wxContextMenuEvent)
        return sipCppV;

    sipCppV = ((const sipClassTypeDef *)sipType_wxCommandEvent)->ctd_cast(static_cast< ::wxCommandEvent *>(sipCpp), targetType);
    if (sipCppV)
        return sipCppV;

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxContextMenuEvent(void *, int);}
static void release_wxContextMenuEvent(void *sipCppV, int sipState)
{
    Py_BEGIN_ALLOW_THREADS

    if (sipState & SIP_DERIVED_CLASS)
        delete reinterpret_cast<sipwxContextMenuEvent *>(sipCppV);
    else
        delete reinterpret_cast< ::wxContextMenuEvent *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void dealloc_wxContextMenuEvent(sipSimpleWrapper *);}
static void dealloc_wxContextMenuEvent(sipSimpleWrapper *sipSelf)
{
    if (sipIsDerivedClass(sipSelf))
        reinterpret_cast<sipwxContextMenuEvent *>(sipGetAddress(sipSelf))->sipPySelf = SIP_NULLPTR;

    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxContextMenuEvent(sipGetAddress(sipSelf), sipIsDerivedClass(sipSelf));
    }
}


extern "C" {static void *init_type_wxContextMenuEvent(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxContextMenuEvent(sipSimpleWrapper *sipSelf, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    sipwxContextMenuEvent *sipCpp = SIP_NULLPTR;

    {
        ::wxEventType type = wxEVT_NULL;
        int id = 0;
        const ::wxPoint& posdef = wxDefaultPosition;
        const ::wxPoint* pos = &posdef;
        int posState = 0;

        static const char *sipKwdList[] = {
            sipName_type,
            sipName_id,
            sipName_pos,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "|iiJ1", &type, &id, sipType_wxPoint, &pos, &posState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxContextMenuEvent(type, id, *pos);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPoint *>(pos), sipType_wxPoint, posState);

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    {
        const ::wxContextMenuEvent* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_wxContextMenuEvent, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxContextMenuEvent(*a0);
            Py_END_ALLOW_THREADS

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_wxContextMenuEvent[] = {{84, 255, 1}};


static PyMethodDef methods_wxContextMenuEvent[] = {
    {sipName_Clone, meth_wxContextMenuEvent_Clone, METH_VARARGS, doc_wxContextMenuEvent_Clone},
    {sipName_GetPosition, meth_wxContextMenuEvent_GetPosition, METH_VARARGS, doc_wxContextMenuEvent_GetPosition},
    {sipName_SetPosition, SIP_MLMETH_CAST(meth_wxContextMenuEvent_SetPosition), METH_VARARGS|METH_KEYWORDS, doc_wxContextMenuEvent_SetPosition}
};

sipVariableDef variables_wxContextMenuEvent[] = {
    {PropertyVariable, sipName_Position, &methods_wxContextMenuEvent[1], &methods_wxContextMenuEvent[2], SIP_NULLPTR, SIP_NULLPTR},
};

PyDoc_STRVAR(doc_wxContextMenuEvent, "ContextMenuEvent(type=wxEVT_NULL, id=0, pos=DefaultPosition) -> None\n"
"\n"
"This class is used for context menu events, sent to give the\n"
"application a chance to show a context (popup) menu for a wxWindow.");


sipClassTypeDef sipTypeDef__core_wxContextMenuEvent = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SCC|SIP_TYPE_CLASS,
        sipNameNr_wxContextMenuEvent,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        sipNameNr_ContextMenuEvent,
        {0, 0, 1},
        3, methods_wxContextMenuEvent,
        0, SIP_NULLPTR,
        1, variables_wxContextMenuEvent,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxContextMenuEvent,
    -1,
    -1,
    supers_wxContextMenuEvent,
    SIP_NULLPTR,
    init_type_wxContextMenuEvent,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_wxContextMenuEvent,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    release_wxContextMenuEvent,
    cast_wxContextMenuEvent,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    sizeof (::wxContextMenuEvent),
};
